/*
 * Decompiled with CFR 0.152.
 */
package io.aether.examples.plainChat;

import io.aether.api.chatdsl.MessageDescriptor;
import io.aether.api.chatdsl.ServiceClientApi;
import io.aether.api.chatdsl.ServiceClientApiRemote;
import io.aether.api.chatdsl.ServiceServerApi;
import io.aether.api.chatdsl.ServiceServerApiLocal;
import io.aether.api.chatdsl.UserDescriptor;
import io.aether.cloud.client.AetherCloudClient;
import io.aether.cloud.client.ClientState;
import io.aether.cloud.client.ClientStateInMemory;
import io.aether.logger.Log;
import io.aether.net.fastMeta.FastApiContextLocal;
import io.aether.utils.flow.Flow;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ChatService {
    public static final ARFuture<UUID> uid = ARFuture.make();
    public final AetherCloudClient aether;
    public final Map<UUID, ServiceClientApiRemote> clients = new ConcurrentHashMap<UUID, ServiceClientApiRemote>();
    final Queue<MessageDescriptor> allMessages = new ConcurrentLinkedQueue<MessageDescriptor>();
    private final Map<UUID, UserDescriptor> users = new ConcurrentHashMap<UUID, UserDescriptor>();

    public ChatService(List<URI> registrationUri) {
        this.aether = new AetherCloudClient((ClientState)new ClientStateInMemory(UUID.fromString("B30AD9CA-FF20-E851-B11F-AED62C584AD2"), registrationUri), "ChatService").waitStart(10);
        uid.done((Object)this.aether.getUid());
        ARFuture groupFuture = this.aether.createAccessGroup(new UUID[0]);
        this.aether.onNewChildren(u -> groupFuture.to(group -> {
            group.add(u).toFuture().to(() -> Log.info((String)"NEW CHILD DONE: $uid", (Object[])new Object[]{"uid", u}));
            Log.info((String)"NEW CHILD: $uid", (Object[])new Object[]{"uid", u});
        }));
        this.aether.onClientStream(s -> {
            FastApiContextLocal api = s.toApiR(ServiceServerApi.META, c -> {
                ServiceClientApiRemote r = (ServiceClientApiRemote)c.makeRemote(ServiceClientApi.META);
                this.clients.put(s.getConsumerUUID(), r);
                return new MyServiceServerApi(s.getConsumerUUID(), r);
            });
        });
    }

    private class MyServiceServerApi
    extends ServiceServerApiLocal<ServiceClientApiRemote> {
        private final UUID uid;

        public MyServiceServerApi(UUID consumerUUID, ServiceClientApiRemote remoteApi) {
            super(remoteApi);
            this.uid = consumerUUID;
        }

        @Override
        public AFuture registration(String name) {
            Log.info((String)"registration: $name", (Object[])new Object[]{"name", name});
            UserDescriptor u = new UserDescriptor(this.uid, name);
            ChatService.this.users.put(this.uid, u);
            for (UserDescriptor uu : ChatService.this.users.values()) {
                ServiceClientApiRemote r = ChatService.this.clients.get(uu.getUid());
                if (r == null) continue;
                r.addNewUsers(new UserDescriptor[]{u});
            }
            ((ServiceClientApiRemote)this.remoteApi).addNewUsers((UserDescriptor[])Flow.flow(ChatService.this.users.values()).toArray(UserDescriptor.class));
            ((ServiceClientApiRemote)this.remoteApi).newMessages((MessageDescriptor[])Flow.flow(ChatService.this.allMessages).toArray(MessageDescriptor.class));
            return AFuture.completed();
        }

        @Override
        public void sendMessage(String msg) {
            Log.info((String)"send message to chat: $msg", (Object[])new Object[]{"msg", msg});
            MessageDescriptor md = new MessageDescriptor(this.uid, msg);
            ChatService.this.allMessages.add(md);
            Collection<UserDescriptor> vv = ChatService.this.users.values();
            if (vv.isEmpty()) {
                Log.warn((String)"no users for send message to chat: $msg", (Object[])new Object[]{"msg", msg});
            } else {
                Log.info((String)"Task chat message: $msg -> [$users]", (Object[])new Object[]{"msg", msg, "users", vv});
            }
            for (UserDescriptor u : vv) {
                ServiceClientApiRemote r = ChatService.this.clients.get(u.getUid());
                Log.info((String)"try send newMessages to remote: $uid", (Object[])new Object[]{"uid", u.getUid()});
                Log.info((String)"send newMessages to remote: $uid", (Object[])new Object[]{"uid", u.getUid()});
                r.newMessages(new MessageDescriptor[]{md});
            }
        }
    }
}

