/*
 * Decompiled with CFR 0.152.
 */
package io.aether.examples.plainChat;

import io.aether.examples.plainChat.ChatClient;
import io.aether.examples.plainChat.ChatService;
import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class PlainChatTest {
    public final List<URI> registrationUri = new ArrayList<URI>();

    public PlainChatTest() {
        this.registrationUri.add(URI.create("tcp://registration.aethernet.io:9010"));
    }

    public AFuture start() {
        ChatService chatService = new ChatService(this.registrationUri);
        ChatClient chatClient1 = new ChatClient(chatService.aether.getUid(), this.registrationUri, "client1");
        ChatClient chatClient2 = new ChatClient(chatService.aether.getUid(), this.registrationUri, "client2");
        Log.info((String)"Client was started", (LNode[])new LNode[0]);
        AFuture res = AFuture.make();
        AFuture.all((AFuture[])new AFuture[]{chatClient1.aether.startFuture, chatClient2.aether.startFuture}).to(() -> {
            ARFuture future = ARFuture.make();
            chatClient2.onMessage.add(m -> {
                Log.info((String)"receive message: $msg", (Object[])new Object[]{"msg", m});
                future.tryDone(m);
            });
            chatClient1.sendMessage("test");
            future.to(m -> Log.info((String)"The message has been received: $msg", (Object[])new Object[]{"msg", m}));
            future.timeoutError(10, "timeout receive message exception");
            future.to(res);
        });
        return res;
    }
}

