/*
 * Decompiled with CFR 0.152.
 */
package io.aether.examples.pointToPoint;

import io.aether.StandardUUIDs;
import io.aether.api.common.CryptoLib;
import io.aether.cloud.client.AetherCloudClient;
import io.aether.cloud.client.ClientState;
import io.aether.cloud.client.ClientStateInMemory;
import io.aether.cloud.client.MessageEventListener;
import io.aether.cloud.client.MessageNode;
import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.utils.ConcurrentHashSet;
import io.aether.utils.RU;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import io.aether.utils.streams.Value;
import io.aether.utils.streams.ValueOfData;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class PointToPointTest {
    public final List<URI> registrationUri = new ArrayList<URI>();
    public ClientStateInMemory clientConfig1;
    public ClientStateInMemory clientConfig2;
    public ClientStateInMemory serviceConfig;

    public PointToPointTest() {
        this.registrationUri.add(URI.create("tcp://registration.aethernet.io:9010"));
    }

    public AFuture p2p() {
        UUID parent = UUID.fromString("B1AC52C8-8D94-BD39-4C01-A631AC594165");
        if (this.clientConfig1 == null) {
            this.clientConfig1 = new ClientStateInMemory(parent, this.registrationUri, null, CryptoLib.SODIUM);
        }
        if (this.clientConfig2 == null) {
            this.clientConfig2 = new ClientStateInMemory(parent, this.registrationUri, null, CryptoLib.HYDROGEN);
        }
        this.clientConfig1.getPingDuration().set((Object)100L);
        this.clientConfig2.getPingDuration().set((Object)100L);
        AetherCloudClient client1 = new AetherCloudClient((ClientState)this.clientConfig1, "client1");
        AetherCloudClient client2 = new AetherCloudClient((ClientState)this.clientConfig2, "client2");
        AFuture testDoneFuture = AFuture.make();
        client1.startFuture.to(() -> Log.info((String)"client is registered uid2: $uid1", (Object[])new Object[]{"uid1", client1.getUid()}));
        client2.startFuture.to(() -> Log.info((String)"client is registered uid2: $uid2", (Object[])new Object[]{"uid2", client2.getUid()}));
        client1.startFuture.onError(x$0 -> Log.error((Throwable)x$0, (Object[])new Object[0]));
        client2.startFuture.onError(x$0 -> Log.error((Throwable)x$0, (Object[])new Object[0]));
        client1.startFuture.onCancel(() -> Log.error((String)"cancel", (Object[])new Object[0]));
        client2.startFuture.onCancel(() -> Log.error((String)"cancel", (Object[])new Object[0]));
        client2.startFuture.onError(x$0 -> Log.error((Throwable)x$0, (Object[])new Object[0]));
        ((AFuture)AFuture.all((AFuture[])new AFuture[]{client1.startFuture, client2.startFuture}).to(() -> {
            Log.info((String)"clients is registered uid1: $uid1 uid2: $uid2", (Object[])new Object[]{"uid1", client1.getUid(), "uid2", client2.getUid()});
            AFuture checkReceiveMessage = AFuture.make();
            byte[] message = new byte[]{1, 2, 3, 4};
            client2.onMessage((uid, msg) -> {
                if (checkReceiveMessage.tryDone()) {
                    Log.info((String)"First message confirm", (LNode[])new LNode[0]);
                } else {
                    Log.warn((String)"Second message confirm", (LNode[])new LNode[0]);
                }
            });
            Log.info((String)"START two clients!", (LNode[])new LNode[0]);
            Thread.currentThread().setName("MAIN THREAD");
            Value m = Value.of((Object)message).timeout(30000L, v -> Log.error((String)"timeout message: $v", (Object[])new Object[]{"v", v}));
            client1.sendMessage(client2.getUid(), m);
            ((AFuture)checkReceiveMessage.to(() -> {
                Log.info((String)"TEST IS DONE!", (LNode[])new LNode[0]);
                ((AFuture)client1.destroy(true).to(() -> client2.destroy(true).to(testDoneFuture).onError(arg_0 -> ((AFuture)testDoneFuture).error(arg_0)))).onError(arg_0 -> ((AFuture)testDoneFuture).error(arg_0));
            })).onError(arg_0 -> ((AFuture)testDoneFuture).error(arg_0));
        })).onError(arg_0 -> ((AFuture)testDoneFuture).error(arg_0));
        return testDoneFuture;
    }

    public AFuture timeOneMessage() {
        UUID parent = UUID.fromString("9128C7D0-4BA1-8D1C-AC9F-71074A014FC5");
        if (this.clientConfig1 == null) {
            this.clientConfig1 = new ClientStateInMemory(parent, this.registrationUri, null, CryptoLib.HYDROGEN);
        }
        if (this.clientConfig2 == null) {
            this.clientConfig2 = new ClientStateInMemory(parent, this.registrationUri, null, CryptoLib.HYDROGEN);
        }
        AetherCloudClient client1 = new AetherCloudClient((ClientState)this.clientConfig1);
        AetherCloudClient client2 = new AetherCloudClient((ClientState)this.clientConfig2);
        AFuture testDoneFuture = AFuture.make();
        ((AFuture)AFuture.all((AFuture[])new AFuture[]{client1.startFuture, client2.startFuture}).to(() -> {
            MessageNode ch1 = client1.getMessageNode(client2.getUid());
            long total = 1000000L;
            AtomicLong receiveCounter = new AtomicLong(0L);
            client2.onClientStream(g -> g.toConsumer(d -> receiveCounter.addAndGet(((byte[])d).length)));
            byte[] data = new byte[10000];
            long timeBegin = RU.time();
            while (receiveCounter.get() < 1000000L) {
                Value v = Value.ofForce((Object)data);
                boolean[] abortFlag = new boolean[1];
                v.onReject((owner, id) -> {
                    abortFlag[0] = true;
                });
                ch1.send(v);
                if (abortFlag[0]) continue;
                RU.sleep((long)10L);
            }
            long timeEnd = RU.time();
            long duration = timeEnd - timeBegin;
            Log.info((String)"Total time: $time. Speed: $speed kB/s", (Object[])new Object[]{"time", duration, "timeBegin", timeBegin, "timeEnd", timeEnd, "speed", (double)(1000000L * (long)data.length) * 8.0 / ((double)duration / 1000.0) / 1024.0});
            testDoneFuture.done();
        })).onError(arg_0 -> ((AFuture)testDoneFuture).error(arg_0));
        return testDoneFuture;
    }

    public AFuture p2pAndBack() {
        UUID parent = UUID.fromString("B0600A31-1ACC-BB39-35C9-F1476C1F40E2");
        if (this.clientConfig1 == null) {
            this.clientConfig1 = new ClientStateInMemory(parent, this.registrationUri, null, CryptoLib.HYDROGEN);
        }
        if (this.clientConfig2 == null) {
            this.clientConfig2 = new ClientStateInMemory(parent, this.registrationUri, null, CryptoLib.HYDROGEN);
        }
        AetherCloudClient client1 = new AetherCloudClient((ClientState)this.clientConfig1, "client1");
        AetherCloudClient client2 = new AetherCloudClient((ClientState)this.clientConfig2, "client2");
        AFuture testDoneFuture = AFuture.make();
        ((AFuture)AFuture.all((AFuture[])new AFuture[]{client1.startFuture, client2.startFuture}).to(() -> {
            Log.info((String)"clients is registered uid1: $uid1 uid2: $uid2", (Object[])new Object[]{"uid1", client1.getUid(), "uid2", client2.getUid()});
            AFuture checkReceiveMessageBack = AFuture.make();
            byte[] message = new byte[]{1, 2, 3, 4};
            byte[] messageBack = new byte[]{1, 1, 1, 1};
            client2.onClientStream(st -> st.toConsumer(newMessage -> st.send(Value.of((Object)messageBack))));
            client1.onClientStream(st -> st.toConsumer(newMessage -> checkReceiveMessageBack.done()));
            Log.info((String)"START two clients!", (LNode[])new LNode[0]);
            MessageNode chToc2 = client1.getMessageNode(client2.getUid());
            Thread.currentThread().setName("MAIN THREAD");
            chToc2.send(Value.ofForce((Object)message));
            ((AFuture)checkReceiveMessageBack.to(() -> {
                Log.info((String)"TEST IS DONE!", (LNode[])new LNode[0]);
                ((AFuture)client1.destroy(true).to(() -> ((AFuture)client2.destroy(true).to(() -> ((AFuture)testDoneFuture).done())).onError(arg_0 -> ((AFuture)testDoneFuture).error(arg_0)))).onError(arg_0 -> ((AFuture)testDoneFuture).error(arg_0));
            })).onError(arg_0 -> ((AFuture)testDoneFuture).error(arg_0));
        })).onError(arg_0 -> ((AFuture)testDoneFuture).error(arg_0));
        return testDoneFuture;
    }

    public AFuture pointToPointWithService() {
        UUID parent = UUID.fromString("A8348A48-64CC-A8EF-6902-090F446247C8");
        if (this.serviceConfig == null) {
            this.serviceConfig = new ClientStateInMemory(parent, this.registrationUri);
        }
        AetherCloudClient service = new AetherCloudClient((ClientState)this.serviceConfig);
        AFuture testDoneFuture = AFuture.make();
        ((AFuture)service.startFuture.to(() -> {
            Log.info((String)"service is registered", (LNode[])new LNode[0]);
            ConcurrentHashSet allChildren = new ConcurrentHashSet();
            ARFuture groupFuture = service.createAccessGroup(new UUID[0]);
            service.onNewChildren(arg_0 -> PointToPointTest.lambda$pointToPointWithService$27(groupFuture, service, (Set)allChildren, arg_0));
            UUID parentUid = service.getUid();
            assert (parentUid != null);
            if (this.clientConfig1 == null) {
                this.clientConfig1 = new ClientStateInMemory(parentUid, this.registrationUri);
            }
            if (this.clientConfig2 == null) {
                this.clientConfig2 = new ClientStateInMemory(parentUid, this.registrationUri);
            }
            AetherCloudClient client1 = new AetherCloudClient((ClientState)this.clientConfig1);
            AetherCloudClient client2 = new AetherCloudClient((ClientState)this.clientConfig2);
            ((AFuture)AFuture.all((AFuture[])new AFuture[]{client1.startFuture, client2.startFuture}).to(() -> {
                Log.info((String)"clients is registered", (LNode[])new LNode[0]);
                AFuture checkReceiveMessage = AFuture.make();
                byte[] message = new byte[]{0, 0, 0, 0};
                client2.onClientStream(st -> st.toConsumer(newMessage -> checkReceiveMessage.done()));
                Log.info((String)"START!", (LNode[])new LNode[0]);
                MessageNode chToc2 = client1.getMessageNode(client2.getUid());
                chToc2.send(Value.ofForce((Object)message));
                ((AFuture)checkReceiveMessage.to(() -> ((AFuture)client1.destroy(true).to(() -> ((AFuture)client2.destroy(true).to(() -> ((AFuture)testDoneFuture).done())).onError(arg_0 -> ((AFuture)testDoneFuture).error(arg_0)))).onError(arg_0 -> ((AFuture)testDoneFuture).error(arg_0)))).onError(arg_0 -> ((AFuture)testDoneFuture).error(arg_0));
            })).onError(arg_0 -> ((AFuture)testDoneFuture).error(arg_0));
        })).onError(arg_0 -> ((AFuture)testDoneFuture).error(arg_0));
        return testDoneFuture;
    }

    public AFuture p2pMany() {
        UUID parent = UUID.fromString("d1401d8c-674d-4948-8d41-c395334ad391");
        if (this.clientConfig1 == null) {
            this.clientConfig1 = new ClientStateInMemory(parent, this.registrationUri, null, CryptoLib.HYDROGEN);
        }
        if (this.clientConfig2 == null) {
            this.clientConfig2 = new ClientStateInMemory(parent, this.registrationUri, null, CryptoLib.HYDROGEN);
        }
        AetherCloudClient client1 = new AetherCloudClient((ClientState)this.clientConfig1, "client1");
        AetherCloudClient client2 = new AetherCloudClient((ClientState)this.clientConfig2, "client2");
        AFuture testDoneFuture = AFuture.make();
        ((AFuture)AFuture.all((AFuture[])new AFuture[]{client1.startFuture, client2.startFuture}).to(() -> {
            Log.info((String)"clients is registered uid1: $uid1 uid2: $uid2", (Object[])new Object[]{"uid1", client1.getUid(), "uid2", client2.getUid()});
            AFuture checkReceiveMessage = AFuture.make();
            byte[] message = new byte[]{1, 2, 3, 4};
            int ITERATIONS = 10;
            ArrayList<MValue> values = new ArrayList<MValue>();
            for (int i = 0; i < ITERATIONS; ++i) {
                values.add(new MValue(message));
            }
            AtomicInteger counter = new AtomicInteger(ITERATIONS);
            client2.onClientStream(st -> {
                Log.debug((String)"onClientStream", (LNode[])new LNode[0]);
                st.toConsumer(newMessage -> {
                    Log.debug((String)"on new message", (LNode[])new LNode[0]);
                    if (counter.addAndGet(-1) == 0) {
                        checkReceiveMessage.done();
                    }
                });
            });
            Log.info((String)"START two clients!", (LNode[])new LNode[0]);
            MessageNode chToc2n = client1.openStreamToClientDetails(client2.getUid(), MessageEventListener.DEFAULT);
            Thread.currentThread().setName("MAIN THREAD");
            for (MValue v : values) {
                chToc2n.send((Value)v);
            }
            ((AFuture)checkReceiveMessage.to(() -> {
                Log.info((String)"TEST IS DONE!", (LNode[])new LNode[0]);
                ((AFuture)client1.destroy(true).to(() -> ((AFuture)client2.destroy(true).to(() -> ((AFuture)testDoneFuture).done())).onError(arg_0 -> ((AFuture)testDoneFuture).error(arg_0)))).onError(arg_0 -> ((AFuture)testDoneFuture).error(arg_0));
            })).onError(arg_0 -> ((AFuture)testDoneFuture).error(arg_0));
        })).onError(arg_0 -> ((AFuture)testDoneFuture).error(arg_0));
        return testDoneFuture;
    }

    private AFuture startIteration2() {
        AFuture iteration2DoneFuture = AFuture.make();
        if (this.clientConfig1 == null) {
            this.clientConfig1 = new ClientStateInMemory(StandardUUIDs.TEST_UID, this.registrationUri, null, CryptoLib.HYDROGEN);
        }
        if (this.clientConfig2 == null) {
            this.clientConfig2 = new ClientStateInMemory(StandardUUIDs.TEST_UID, this.registrationUri, null, CryptoLib.HYDROGEN);
        }
        AetherCloudClient client1 = new AetherCloudClient((ClientState)this.clientConfig1, "client1_2");
        AetherCloudClient client2 = new AetherCloudClient((ClientState)this.clientConfig2, "client2_2");
        ((AFuture)AFuture.all((AFuture[])new AFuture[]{client1.startFuture, client2.startFuture}).to(() -> {
            Log.info((String)"clients is registered uid1: $uid1 uid2: $uid2", (Object[])new Object[]{"uid1", client1.getUid(), "uid2", client2.getUid()});
            AFuture checkReceiveMessage = AFuture.make();
            byte[] message = new byte[]{2, 2, 2, 2};
            client2.onClientStream(st -> st.toConsumer(newMessage -> checkReceiveMessage.done()));
            Log.info((String)"START two clients!", (LNode[])new LNode[0]);
            MessageNode chToc2 = client1.getMessageNode(client2.getUid());
            Thread.currentThread().setName("MAIN THREAD");
            chToc2.send(Value.ofForce((Object)message));
            ((AFuture)checkReceiveMessage.to(() -> {
                Log.info((String)"TEST IS DONE!", (LNode[])new LNode[0]);
                ((AFuture)AFuture.all((AFuture[])new AFuture[]{client1.destroy(true), client2.destroy(true)}).to(() -> ((AFuture)iteration2DoneFuture).done())).onError(arg_0 -> ((AFuture)iteration2DoneFuture).error(arg_0));
            })).onError(arg_0 -> ((AFuture)iteration2DoneFuture).error(arg_0));
        })).onError(arg_0 -> ((AFuture)iteration2DoneFuture).error(arg_0));
        return iteration2DoneFuture;
    }

    public AFuture pointToPointWithReconnect() {
        UUID parent = UUID.fromString("84AE8BD0-2BE4-FF65-406C-B1B655444D54");
        this.clientConfig1 = new ClientStateInMemory(parent, this.registrationUri);
        this.clientConfig2 = new ClientStateInMemory(parent, this.registrationUri);
        AFuture testDoneFuture = AFuture.make();
        if (this.clientConfig1 == null) {
            this.clientConfig1 = new ClientStateInMemory(StandardUUIDs.TEST_UID, this.registrationUri, null, CryptoLib.HYDROGEN);
        }
        if (this.clientConfig2 == null) {
            this.clientConfig2 = new ClientStateInMemory(StandardUUIDs.TEST_UID, this.registrationUri, null, CryptoLib.HYDROGEN);
        }
        AetherCloudClient client1 = new AetherCloudClient((ClientState)this.clientConfig1, "client1");
        AetherCloudClient client2 = new AetherCloudClient((ClientState)this.clientConfig2, "client2");
        ((AFuture)AFuture.all((AFuture[])new AFuture[]{client1.startFuture, client2.startFuture}).to(() -> {
            Log.info((String)"clients is registered uid1: $uid1 uid2: $uid2", (Object[])new Object[]{"uid1", client1.getUid(), "uid2", client2.getUid()});
            AFuture checkReceiveMessage = AFuture.make();
            byte[] message = new byte[]{1, 1, 1, 1};
            client2.onClientStream(st -> st.toConsumer(newMessage -> checkReceiveMessage.done()));
            Log.info((String)"START two clients!", (LNode[])new LNode[0]);
            MessageNode chToc2 = client1.getMessageNode(client2.getUid());
            Thread.currentThread().setName("MAIN THREAD");
            chToc2.send(Value.ofForce((Object)message));
            ((AFuture)checkReceiveMessage.to(() -> {
                Log.info((String)"TEST IS DONE!", (LNode[])new LNode[0]);
                AFuture f1 = client1.destroy(true);
                AFuture f2 = client2.destroy(true);
                ((AFuture)AFuture.all((AFuture[])new AFuture[]{f1, f2}).onError(t -> testDoneFuture.error((Throwable)new IllegalStateException("Failed to destroy clients after iteration 1: " + String.valueOf(f1) + ":" + String.valueOf(f2), (Throwable)t)))).to(() -> {
                    Log.debug((String)"ITERATION 2 START", (LNode[])new LNode[0]);
                    ((AFuture)this.startIteration2().to(() -> ((AFuture)testDoneFuture).done())).onError(arg_0 -> ((AFuture)testDoneFuture).error(arg_0));
                });
            })).onError(arg_0 -> ((AFuture)testDoneFuture).error(arg_0));
        })).onError(arg_0 -> ((AFuture)testDoneFuture).error(arg_0));
        return testDoneFuture;
    }

    private static /* synthetic */ void lambda$pointToPointWithService$27(ARFuture groupFuture, AetherCloudClient service, Set allChildren, UUID u) throws Throwable {
        groupFuture.to(group -> {
            service.getClientApi(u, a -> a.addAccessGroup(group.getId()).to(f -> {
                allChildren.add(u);
                Log.info((String)"NEW CHILD DONE: $uid", (Object[])new Object[]{"uid", u, "result", f});
            }).onError(e -> Log.error((String)"Failed to add access group: $e", (Object[])new Object[]{"e", e})));
            Log.info((String)"NEW CHILD: $uid", (Object[])new Object[]{"uid", u});
        });
    }

    private static class MValue
    extends ValueOfData<byte[]> {
        public final List<Object> enters = new ArrayList<Object>();
        volatile boolean abort;
        volatile boolean drop;

        public MValue(byte[] message) {
            super((Object)message);
        }

        public void reject(Object owner, long blockId) {
            this.enters.add(owner);
            this.abort = true;
        }

        public void success(Object owner) {
            this.enters.add(owner);
            this.drop = true;
        }

        public void enter(Object owner) {
            this.enters.add(owner);
        }
    }
}

