package io.aether.api.smarthome;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class Record implements io.aether.utils.ToString {
    public static final FastMetaType<Record> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_0, Record obj_1, DataOut out_2) {
            out_2.writeByte(obj_1.value);
            out_2.writeByte(obj_1.time);
            
        }
        @Override public Record deserialize(FastFutureContext serializeContextVar_0, DataIn in_3) {
            byte value_4;
            byte time_5;
            value_4=in_3.readByte();
            time_5=in_3.readByte();
            return new Record(value_4,time_5);
            
        }
        
    };
    public static final FastMetaType<Record> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_6, Record obj_7, DataOut out_8) {
            Record.META_BODY.serialize(serializeContextVar_6, obj_7, out_8);
            
        }
        @Override public Record deserialize(FastFutureContext serializeContextVar_6, DataIn in_9) {
            return Record.META_BODY.deserialize(serializeContextVar_6, in_9);
            
        }
        
    };
    protected final byte value;
    protected final byte time;
    public Record(byte value, byte time) {
        this.value = value;
        this.time = time;
        
    }
    public byte getValue() {
        return this.value;
        
    }
    public byte getTime() {
        return this.time;
        
    }
    @Override public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || !(o instanceof Record)) return false;
        Record that = (Record) o;
        return java.util.Objects.equals(this.value, that.value) && java.util.Objects.equals(this.time, that.time);
        
    }
    @Override public int hashCode() {
        return java.util.Objects.hash(this.value, this.time);
        
    }
    @Override public String toString() {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb) {
        sb.add("Record(");
        sb.add("value:");
        sb.add(this.value);
        sb.add(", ");
        sb.add("time:");
        sb.add(this.time);
        sb.add(')');
        
    }
    
}