package io.aether.api.smarthome;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public interface SimpleClientApi {
    FastMetaApi<SimpleClientApi,SimpleClientApiRemote> META=new FastMetaApi<>() {
        public void makeLocal(FastFutureContext serializeContextVar_25, DataIn in_, SimpleClientApi localApi) {
            while(in_.isReadable()) {
                byte commandId = in_.readByte();
                switch(commandId) {
                    case 0: {
                        var requestId_26 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_25,in_);
                        var futureRec_27 = serializeContextVar_25.getFuture(requestId_26);
                        if(futureRec_27 != null) futureRec_27.onDone(in_);
                        break;
                        
                    }
                    case 1: {
                        var requestId_28 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_25,in_);
                        var futureRec_29 = serializeContextVar_25.getFuture(requestId_28);
                        if(futureRec_29 != null) futureRec_29.onError(in_);
                        break;
                        
                    }
                    case 3: {
                        Record[] value_31;
                        var arraySize_32 = DeserializerPackNumber.INSTANCE.put(in_).intValue();
                        value_31=new Record[arraySize_32];
                        for(var forVar_33=0; forVar_33<arraySize_32; forVar_33++) {
                            value_31[forVar_33]=Record.META.deserialize(serializeContextVar_25,in_);
                            
                        }
                        String[] argsNames_34 = new String[] {
                            "value"
                        };
                        Object[] argsValues_35 = new Object[] {
                            value_31
                        };
                        serializeContextVar_25.invokeLocalMethodBefore("receiveStatus", argsNames_34, argsValues_35);
                        localApi.receiveStatus(value_31);
                        serializeContextVar_25.invokeLocalMethodAfter("receiveStatus", null, argsNames_34, argsValues_35);
                        break;
                        
                    }
                    default: throw new IllegalArgumentException("Unknown command ID: " + commandId);
                    
                }
                
            }
            
        }
        public SimpleClientApiRemote makeRemote(FastFutureContext localApi_37) {
            return new SimpleClientApiRemote() {
                @Override public void flush(AFuture sendFuture) {
                    localApi_37.flush(sendFuture);
                    
                }
                public io.aether.net.fastMeta.FastFutureContext getFastMetaContext() {
                    return localApi_37;
                    
                }
                @Override public @Command(3) void receiveStatus(Record[] value) {
                    var dataOut_38 = new DataInOut();
                    dataOut_38.writeByte(3);
                    String[] argsNames_40 = new String[] {
                        "value"
                    };
                    Object[] argsValues_41 = new Object[] {
                        value
                    };
                    localApi_37.invokeRemoteMethodAfter("receiveStatus", null, argsNames_40, argsValues_41);
                    SerializerPackNumber.INSTANCE.put(dataOut_38,value.length);
                    for(var forVar_42:value) {
                        Record.META.serialize(localApi_37,forVar_42,dataOut_38);
                        
                    }
                    localApi_37.sendToRemote(dataOut_38.toArray());
                    
                }
                
            };
            
        }
        
    };
    @Command(3) void receiveStatus(Record[] value);
    
}