package io.aether.api.smarthome;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public interface SimpleDeviceApi {
    FastMetaApi<SimpleDeviceApi,SimpleDeviceApiRemote> META=new FastMetaApi<>() {
        public void makeLocal(FastFutureContext serializeContextVar_10, DataIn in_, SimpleDeviceApi localApi) {
            while(in_.isReadable()) {
                byte commandId = in_.readByte();
                switch(commandId) {
                    case 0: {
                        var requestId_11 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_10,in_);
                        var futureRec_12 = serializeContextVar_10.getFuture(requestId_11);
                        if(futureRec_12 != null) futureRec_12.onDone(in_);
                        break;
                        
                    }
                    case 1: {
                        var requestId_13 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_10,in_);
                        var futureRec_14 = serializeContextVar_10.getFuture(requestId_13);
                        if(futureRec_14 != null) futureRec_14.onError(in_);
                        break;
                        
                    }
                    case 3: {
                        short count_16;
                        count_16=in_.readShort();
                        String[] argsNames_17 = new String[] {
                            "count"
                        };
                        Object[] argsValues_18 = new Object[] {
                            count_16
                        };
                        serializeContextVar_10.invokeLocalMethodBefore("requestRecords", argsNames_17, argsValues_18);
                        localApi.requestRecords(count_16);
                        serializeContextVar_10.invokeLocalMethodAfter("requestRecords", null, argsNames_17, argsValues_18);
                        break;
                        
                    }
                    default: throw new IllegalArgumentException("Unknown command ID: " + commandId);
                    
                }
                
            }
            
        }
        public SimpleDeviceApiRemote makeRemote(FastFutureContext localApi_20) {
            return new SimpleDeviceApiRemote() {
                @Override public void flush(AFuture sendFuture) {
                    localApi_20.flush(sendFuture);
                    
                }
                public io.aether.net.fastMeta.FastFutureContext getFastMetaContext() {
                    return localApi_20;
                    
                }
                @Override public @Command(3) void requestRecords(short count) {
                    var dataOut_21 = new DataInOut();
                    dataOut_21.writeByte(3);
                    String[] argsNames_23 = new String[] {
                        "count"
                    };
                    Object[] argsValues_24 = new Object[] {
                        count
                    };
                    localApi_20.invokeRemoteMethodAfter("requestRecords", null, argsNames_23, argsValues_24);
                    dataOut_21.writeShort(count);
                    localApi_20.sendToRemote(dataOut_21.toArray());
                    
                }
                
            };
            
        }
        
    };
    @Command(3) void requestRecords(short count);
    
}