package io.aether.api.smarthome.gui.state;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class AppStateData implements io.aether.utils.ToString {
    public static final FastMetaType<AppStateData> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_64, AppStateData obj_65, DataOut out_66) {
            byte _mask = 0;
            if(obj_65.targetCommutatorUuid == null) _mask |= 1;
            out_66.writeByte(_mask);
            out_66.writeInt(obj_65.pollingTimeoutMs);
            out_66.writeInt(obj_65.pollingBufferSize);
            out_66.writeInt(obj_65.targetDeviceId);
            if(obj_65.targetCommutatorUuid != null) {
                var stringData_68=obj_65.targetCommutatorUuid.getBytes();
                SerializerPackNumber.INSTANCE.put(out_66,stringData_68.length);
                out_66.write(stringData_68);
                
            }
            SerializerPackNumber.INSTANCE.put(out_66,obj_65.knownCommutators.length);
            for(var forVar_69:obj_65.knownCommutators) {
                KnownCommutator.META.serialize(serializeContextVar_64,forVar_69,out_66);
                
            }
            SerializerPackNumber.INSTANCE.put(out_66,obj_65.sensorHistory.length);
            for(var forVar_70:obj_65.sensorHistory) {
                SensorHistorySeries.META.serialize(serializeContextVar_64,forVar_70,out_66);
                
            }
            SerializerPackNumber.INSTANCE.put(out_66,obj_65.rttMetrics.length);
            for(var forVar_71:obj_65.rttMetrics) {
                MetricPoint.META.serialize(serializeContextVar_64,forVar_71,out_66);
                
            }
            out_66.writeInt(obj_65.totalRequests);
            out_66.writeInt(obj_65.packetLossCount);
            SerializerPackNumber.INSTANCE.put(out_66,obj_65.visibleSensorKeys.length);
            for(var forVar_72:obj_65.visibleSensorKeys) {
                var stringData_73=forVar_72.getBytes();
                SerializerPackNumber.INSTANCE.put(out_66,stringData_73.length);
                out_66.write(stringData_73);
                
            }
            
        }
        @Override public AppStateData deserialize(FastFutureContext serializeContextVar_64, DataIn in_67) {
            int pollingTimeoutMs_74;
            int pollingBufferSize_75;
            int targetDeviceId_76;
            String targetCommutatorUuid_77;
            KnownCommutator[] knownCommutators_78;
            SensorHistorySeries[] sensorHistory_79;
            MetricPoint[] rttMetrics_80;
            int totalRequests_81;
            int packetLossCount_82;
            String[] visibleSensorKeys_83;
            byte _mask = in_67.readByte();
            pollingTimeoutMs_74=in_67.readInt();
            pollingBufferSize_75=in_67.readInt();
            targetDeviceId_76=in_67.readInt();
            if ((_mask & 1) == 0) {
                byte[] stringData_84;
                var arraySize_85 = DeserializerPackNumber.INSTANCE.put(in_67).intValue();
                stringData_84=new byte[arraySize_85];
                in_67.read(stringData_84);
                targetCommutatorUuid_77=new String(stringData_84);
                
            }
            else {
                targetCommutatorUuid_77 = null;
                
            }
            var arraySize_86 = DeserializerPackNumber.INSTANCE.put(in_67).intValue();
            knownCommutators_78=new KnownCommutator[arraySize_86];
            for(var forVar_87=0; forVar_87<arraySize_86; forVar_87++) {
                knownCommutators_78[forVar_87]=KnownCommutator.META.deserialize(serializeContextVar_64,in_67);
                
            }
            var arraySize_88 = DeserializerPackNumber.INSTANCE.put(in_67).intValue();
            sensorHistory_79=new SensorHistorySeries[arraySize_88];
            for(var forVar_89=0; forVar_89<arraySize_88; forVar_89++) {
                sensorHistory_79[forVar_89]=SensorHistorySeries.META.deserialize(serializeContextVar_64,in_67);
                
            }
            var arraySize_90 = DeserializerPackNumber.INSTANCE.put(in_67).intValue();
            rttMetrics_80=new MetricPoint[arraySize_90];
            for(var forVar_91=0; forVar_91<arraySize_90; forVar_91++) {
                rttMetrics_80[forVar_91]=MetricPoint.META.deserialize(serializeContextVar_64,in_67);
                
            }
            totalRequests_81=in_67.readInt();
            packetLossCount_82=in_67.readInt();
            var arraySize_92 = DeserializerPackNumber.INSTANCE.put(in_67).intValue();
            visibleSensorKeys_83=new String[arraySize_92];
            for(var forVar_93=0; forVar_93<arraySize_92; forVar_93++) {
                byte[] stringData_94;
                var arraySize_95 = DeserializerPackNumber.INSTANCE.put(in_67).intValue();
                stringData_94=new byte[arraySize_95];
                in_67.read(stringData_94);
                visibleSensorKeys_83[forVar_93]=new String(stringData_94);
                
            }
            return new AppStateData(pollingTimeoutMs_74,pollingBufferSize_75,targetDeviceId_76,targetCommutatorUuid_77,knownCommutators_78,sensorHistory_79,rttMetrics_80,totalRequests_81,packetLossCount_82,visibleSensorKeys_83);
            
        }
        
    };
    public static final FastMetaType<AppStateData> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_96, AppStateData obj_97, DataOut out_98) {
            AppStateData.META_BODY.serialize(serializeContextVar_96, obj_97, out_98);
            
        }
        @Override public AppStateData deserialize(FastFutureContext serializeContextVar_96, DataIn in_99) {
            return AppStateData.META_BODY.deserialize(serializeContextVar_96, in_99);
            
        }
        
    };
    protected final int pollingTimeoutMs;
    protected final int pollingBufferSize;
    protected final int targetDeviceId;
    protected final @MNullable String targetCommutatorUuid;
    protected final KnownCommutator[] knownCommutators;
    protected final SensorHistorySeries[] sensorHistory;
    protected final MetricPoint[] rttMetrics;
    protected final int totalRequests;
    protected final int packetLossCount;
    protected final String[] visibleSensorKeys;
    public AppStateData(int pollingTimeoutMs, int pollingBufferSize, int targetDeviceId, String targetCommutatorUuid, KnownCommutator[] knownCommutators, SensorHistorySeries[] sensorHistory, MetricPoint[] rttMetrics, int totalRequests, int packetLossCount, String[] visibleSensorKeys) {
        if (knownCommutators == null) {
            throw new java.lang.NullPointerException("Field 'knownCommutators' cannot be null.");
            
        }
        if (sensorHistory == null) {
            throw new java.lang.NullPointerException("Field 'sensorHistory' cannot be null.");
            
        }
        if (rttMetrics == null) {
            throw new java.lang.NullPointerException("Field 'rttMetrics' cannot be null.");
            
        }
        if (visibleSensorKeys == null) {
            throw new java.lang.NullPointerException("Field 'visibleSensorKeys' cannot be null.");
            
        }
        this.pollingTimeoutMs = pollingTimeoutMs;
        this.pollingBufferSize = pollingBufferSize;
        this.targetDeviceId = targetDeviceId;
        this.targetCommutatorUuid = targetCommutatorUuid;
        this.knownCommutators = knownCommutators;
        this.sensorHistory = sensorHistory;
        this.rttMetrics = rttMetrics;
        this.totalRequests = totalRequests;
        this.packetLossCount = packetLossCount;
        this.visibleSensorKeys = visibleSensorKeys;
        
    }
    public int getPollingTimeoutMs() {
        return this.pollingTimeoutMs;
        
    }
    public int getPollingBufferSize() {
        return this.pollingBufferSize;
        
    }
    public int getTargetDeviceId() {
        return this.targetDeviceId;
        
    }
    public String getTargetCommutatorUuid() {
        return this.targetCommutatorUuid;
        
    }
    public KnownCommutator[] getKnownCommutators() {
        return this.knownCommutators;
        
    }
    public boolean knownCommutatorsContains(KnownCommutator el) {
        return ObjectSet.of(this.knownCommutators).contains(el);
        
    }
    public SensorHistorySeries[] getSensorHistory() {
        return this.sensorHistory;
        
    }
    public boolean sensorHistoryContains(SensorHistorySeries el) {
        return ObjectSet.of(this.sensorHistory).contains(el);
        
    }
    public MetricPoint[] getRttMetrics() {
        return this.rttMetrics;
        
    }
    public boolean rttMetricsContains(MetricPoint el) {
        return ObjectSet.of(this.rttMetrics).contains(el);
        
    }
    public int getTotalRequests() {
        return this.totalRequests;
        
    }
    public int getPacketLossCount() {
        return this.packetLossCount;
        
    }
    public String[] getVisibleSensorKeys() {
        return this.visibleSensorKeys;
        
    }
    public boolean visibleSensorKeysContains(String el) {
        return ObjectSet.of(this.visibleSensorKeys).contains(el);
        
    }
    @Override public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || !(o instanceof AppStateData)) return false;
        AppStateData that = (AppStateData) o;
        return java.util.Objects.equals(this.pollingTimeoutMs, that.pollingTimeoutMs) && java.util.Objects.equals(this.pollingBufferSize, that.pollingBufferSize) && java.util.Objects.equals(this.targetDeviceId, that.targetDeviceId) && java.util.Objects.equals(this.targetCommutatorUuid, that.targetCommutatorUuid) && java.util.Arrays.equals(this.knownCommutators, that.knownCommutators) && java.util.Arrays.equals(this.sensorHistory, that.sensorHistory) && java.util.Arrays.equals(this.rttMetrics, that.rttMetrics) && java.util.Objects.equals(this.totalRequests, that.totalRequests) && java.util.Objects.equals(this.packetLossCount, that.packetLossCount) && java.util.Arrays.equals(this.visibleSensorKeys, that.visibleSensorKeys);
        
    }
    @Override public int hashCode() {
        return java.util.Objects.hash(this.pollingTimeoutMs, this.pollingBufferSize, this.targetDeviceId, this.targetCommutatorUuid, java.util.Arrays.hashCode(this.knownCommutators), java.util.Arrays.hashCode(this.sensorHistory), java.util.Arrays.hashCode(this.rttMetrics), this.totalRequests, this.packetLossCount, java.util.Arrays.hashCode(this.visibleSensorKeys));
        
    }
    @Override public String toString() {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb) {
        sb.add("AppStateData(");
        sb.add("pollingTimeoutMs:");
        sb.add(this.pollingTimeoutMs);
        sb.add(", ");
        sb.add("pollingBufferSize:");
        sb.add(this.pollingBufferSize);
        sb.add(", ");
        sb.add("targetDeviceId:");
        sb.add(this.targetDeviceId);
        sb.add(", ");
        sb.add("targetCommutatorUuid:");
        sb.add(this.targetCommutatorUuid);
        sb.add(", ");
        sb.add("knownCommutators:");
        sb.add(this.knownCommutators);
        sb.add(", ");
        sb.add("sensorHistory:");
        sb.add(this.sensorHistory);
        sb.add(", ");
        sb.add("rttMetrics:");
        sb.add(this.rttMetrics);
        sb.add(", ");
        sb.add("totalRequests:");
        sb.add(this.totalRequests);
        sb.add(", ");
        sb.add("packetLossCount:");
        sb.add(this.packetLossCount);
        sb.add(", ");
        sb.add("visibleSensorKeys:");
        sb.add(this.visibleSensorKeys);
        sb.add(')');
        
    }
    
}