package io.aether.api.smarthome.gui.state;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class GraphPoint implements io.aether.utils.ToString {
    public static final FastMetaType<GraphPoint> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_0, GraphPoint obj_1, DataOut out_2) {
            out_2.writeLong(obj_1.timestamp);
            out_2.writeDouble(obj_1.value);
            
        }
        @Override public GraphPoint deserialize(FastFutureContext serializeContextVar_0, DataIn in_3) {
            long timestamp_4;
            double value_5;
            timestamp_4=in_3.readLong();
            value_5=in_3.readDouble();
            return new GraphPoint(timestamp_4,value_5);
            
        }
        
    };
    public static final FastMetaType<GraphPoint> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_6, GraphPoint obj_7, DataOut out_8) {
            GraphPoint.META_BODY.serialize(serializeContextVar_6, obj_7, out_8);
            
        }
        @Override public GraphPoint deserialize(FastFutureContext serializeContextVar_6, DataIn in_9) {
            return GraphPoint.META_BODY.deserialize(serializeContextVar_6, in_9);
            
        }
        
    };
    protected final long timestamp;
    protected final double value;
    public GraphPoint(long timestamp, double value) {
        this.timestamp = timestamp;
        this.value = value;
        
    }
    public long getTimestamp() {
        return this.timestamp;
        
    }
    public double getValue() {
        return this.value;
        
    }
    @Override public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || !(o instanceof GraphPoint)) return false;
        GraphPoint that = (GraphPoint) o;
        return java.util.Objects.equals(this.timestamp, that.timestamp) && java.util.Objects.equals(this.value, that.value);
        
    }
    @Override public int hashCode() {
        return java.util.Objects.hash(this.timestamp, this.value);
        
    }
    @Override public String toString() {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb) {
        sb.add("GraphPoint(");
        sb.add("timestamp:");
        sb.add(this.timestamp);
        sb.add(", ");
        sb.add("value:");
        sb.add(this.value);
        sb.add(')');
        
    }
    
}