package io.aether.api.smarthome.gui.state;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class KnownCommutator implements io.aether.utils.ToString {
    public static final FastMetaType<KnownCommutator> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_35, KnownCommutator obj_36, DataOut out_37) {
            byte _mask = 0;
            if(obj_36.label == null) _mask |= 1;
            out_37.writeByte(_mask);
            var stringData_39=obj_36.uuid.getBytes();
            SerializerPackNumber.INSTANCE.put(out_37,stringData_39.length);
            out_37.write(stringData_39);
            if(obj_36.label != null) {
                var stringData_40=obj_36.label.getBytes();
                SerializerPackNumber.INSTANCE.put(out_37,stringData_40.length);
                out_37.write(stringData_40);
                
            }
            out_37.writeLong(obj_36.lastSeen);
            out_37.writeInt(obj_36.totalRequests);
            out_37.writeInt(obj_36.totalResponses);
            
        }
        @Override public KnownCommutator deserialize(FastFutureContext serializeContextVar_35, DataIn in_38) {
            String uuid_41;
            String label_42;
            long lastSeen_43;
            int totalRequests_44;
            int totalResponses_45;
            byte _mask = in_38.readByte();
            byte[] stringData_46;
            var arraySize_47 = DeserializerPackNumber.INSTANCE.put(in_38).intValue();
            stringData_46=new byte[arraySize_47];
            in_38.read(stringData_46);
            uuid_41=new String(stringData_46);
            if ((_mask & 1) == 0) {
                byte[] stringData_48;
                var arraySize_49 = DeserializerPackNumber.INSTANCE.put(in_38).intValue();
                stringData_48=new byte[arraySize_49];
                in_38.read(stringData_48);
                label_42=new String(stringData_48);
                
            }
            else {
                label_42 = null;
                
            }
            lastSeen_43=in_38.readLong();
            totalRequests_44=in_38.readInt();
            totalResponses_45=in_38.readInt();
            return new KnownCommutator(uuid_41,label_42,lastSeen_43,totalRequests_44,totalResponses_45);
            
        }
        
    };
    public static final FastMetaType<KnownCommutator> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_50, KnownCommutator obj_51, DataOut out_52) {
            KnownCommutator.META_BODY.serialize(serializeContextVar_50, obj_51, out_52);
            
        }
        @Override public KnownCommutator deserialize(FastFutureContext serializeContextVar_50, DataIn in_53) {
            return KnownCommutator.META_BODY.deserialize(serializeContextVar_50, in_53);
            
        }
        
    };
    protected final String uuid;
    protected final @MNullable String label;
    protected final long lastSeen;
    protected final int totalRequests;
    protected final int totalResponses;
    public KnownCommutator(String uuid, String label, long lastSeen, int totalRequests, int totalResponses) {
        this.uuid = uuid;
        this.label = label;
        this.lastSeen = lastSeen;
        this.totalRequests = totalRequests;
        this.totalResponses = totalResponses;
        
    }
    public String getUuid() {
        return this.uuid;
        
    }
    public String getLabel() {
        return this.label;
        
    }
    public long getLastSeen() {
        return this.lastSeen;
        
    }
    public int getTotalRequests() {
        return this.totalRequests;
        
    }
    public int getTotalResponses() {
        return this.totalResponses;
        
    }
    @Override public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || !(o instanceof KnownCommutator)) return false;
        KnownCommutator that = (KnownCommutator) o;
        return java.util.Objects.equals(this.uuid, that.uuid) && java.util.Objects.equals(this.label, that.label) && java.util.Objects.equals(this.lastSeen, that.lastSeen) && java.util.Objects.equals(this.totalRequests, that.totalRequests) && java.util.Objects.equals(this.totalResponses, that.totalResponses);
        
    }
    @Override public int hashCode() {
        return java.util.Objects.hash(this.uuid, this.label, this.lastSeen, this.totalRequests, this.totalResponses);
        
    }
    @Override public String toString() {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb) {
        sb.add("KnownCommutator(");
        sb.add("uuid:");
        sb.add(this.uuid);
        sb.add(", ");
        sb.add("label:");
        sb.add(this.label);
        sb.add(", ");
        sb.add("lastSeen:");
        sb.add(this.lastSeen);
        sb.add(", ");
        sb.add("totalRequests:");
        sb.add(this.totalRequests);
        sb.add(", ");
        sb.add("totalResponses:");
        sb.add(this.totalResponses);
        sb.add(')');
        
    }
    
}