package io.aether.api.smarthome.gui.state;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class MetricPoint implements io.aether.utils.ToString {
    public static final FastMetaType<MetricPoint> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_54, MetricPoint obj_55, DataOut out_56) {
            out_56.writeLong(obj_55.timestamp);
            out_56.writeInt(obj_55.rtt);
            
        }
        @Override public MetricPoint deserialize(FastFutureContext serializeContextVar_54, DataIn in_57) {
            long timestamp_58;
            int rtt_59;
            timestamp_58=in_57.readLong();
            rtt_59=in_57.readInt();
            return new MetricPoint(timestamp_58,rtt_59);
            
        }
        
    };
    public static final FastMetaType<MetricPoint> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_60, MetricPoint obj_61, DataOut out_62) {
            MetricPoint.META_BODY.serialize(serializeContextVar_60, obj_61, out_62);
            
        }
        @Override public MetricPoint deserialize(FastFutureContext serializeContextVar_60, DataIn in_63) {
            return MetricPoint.META_BODY.deserialize(serializeContextVar_60, in_63);
            
        }
        
    };
    protected final long timestamp;
    protected final int rtt;
    public MetricPoint(long timestamp, int rtt) {
        this.timestamp = timestamp;
        this.rtt = rtt;
        
    }
    public long getTimestamp() {
        return this.timestamp;
        
    }
    public int getRtt() {
        return this.rtt;
        
    }
    @Override public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || !(o instanceof MetricPoint)) return false;
        MetricPoint that = (MetricPoint) o;
        return java.util.Objects.equals(this.timestamp, that.timestamp) && java.util.Objects.equals(this.rtt, that.rtt);
        
    }
    @Override public int hashCode() {
        return java.util.Objects.hash(this.timestamp, this.rtt);
        
    }
    @Override public String toString() {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb) {
        sb.add("MetricPoint(");
        sb.add("timestamp:");
        sb.add(this.timestamp);
        sb.add(", ");
        sb.add("rtt:");
        sb.add(this.rtt);
        sb.add(')');
        
    }
    
}