package io.aether.api.smarthome.gui.state;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class SensorHistorySeries implements io.aether.utils.ToString {
    public static final FastMetaType<SensorHistorySeries> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_10, SensorHistorySeries obj_11, DataOut out_12) {
            byte _mask = 0;
            if(obj_11.unit == null) _mask |= 1;
            out_12.writeByte(_mask);
            var stringData_14=obj_11.commutatorUuid.getBytes();
            SerializerPackNumber.INSTANCE.put(out_12,stringData_14.length);
            out_12.write(stringData_14);
            out_12.writeInt(obj_11.deviceId);
            var stringData_15=obj_11.deviceName.getBytes();
            SerializerPackNumber.INSTANCE.put(out_12,stringData_15.length);
            out_12.write(stringData_15);
            if(obj_11.unit != null) {
                var stringData_16=obj_11.unit.getBytes();
                SerializerPackNumber.INSTANCE.put(out_12,stringData_16.length);
                out_12.write(stringData_16);
                
            }
            SerializerPackNumber.INSTANCE.put(out_12,obj_11.points.length);
            for(var forVar_17:obj_11.points) {
                GraphPoint.META.serialize(serializeContextVar_10,forVar_17,out_12);
                
            }
            
        }
        @Override public SensorHistorySeries deserialize(FastFutureContext serializeContextVar_10, DataIn in_13) {
            String commutatorUuid_18;
            int deviceId_19;
            String deviceName_20;
            String unit_21;
            GraphPoint[] points_22;
            byte _mask = in_13.readByte();
            byte[] stringData_23;
            var arraySize_24 = DeserializerPackNumber.INSTANCE.put(in_13).intValue();
            stringData_23=new byte[arraySize_24];
            in_13.read(stringData_23);
            commutatorUuid_18=new String(stringData_23);
            deviceId_19=in_13.readInt();
            byte[] stringData_25;
            var arraySize_26 = DeserializerPackNumber.INSTANCE.put(in_13).intValue();
            stringData_25=new byte[arraySize_26];
            in_13.read(stringData_25);
            deviceName_20=new String(stringData_25);
            if ((_mask & 1) == 0) {
                byte[] stringData_27;
                var arraySize_28 = DeserializerPackNumber.INSTANCE.put(in_13).intValue();
                stringData_27=new byte[arraySize_28];
                in_13.read(stringData_27);
                unit_21=new String(stringData_27);
                
            }
            else {
                unit_21 = null;
                
            }
            var arraySize_29 = DeserializerPackNumber.INSTANCE.put(in_13).intValue();
            points_22=new GraphPoint[arraySize_29];
            for(var forVar_30=0; forVar_30<arraySize_29; forVar_30++) {
                points_22[forVar_30]=GraphPoint.META.deserialize(serializeContextVar_10,in_13);
                
            }
            return new SensorHistorySeries(commutatorUuid_18,deviceId_19,deviceName_20,unit_21,points_22);
            
        }
        
    };
    public static final FastMetaType<SensorHistorySeries> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_31, SensorHistorySeries obj_32, DataOut out_33) {
            SensorHistorySeries.META_BODY.serialize(serializeContextVar_31, obj_32, out_33);
            
        }
        @Override public SensorHistorySeries deserialize(FastFutureContext serializeContextVar_31, DataIn in_34) {
            return SensorHistorySeries.META_BODY.deserialize(serializeContextVar_31, in_34);
            
        }
        
    };
    protected final String commutatorUuid;
    protected final int deviceId;
    protected final String deviceName;
    protected final @MNullable String unit;
    protected final GraphPoint[] points;
    public SensorHistorySeries(String commutatorUuid, int deviceId, String deviceName, String unit, GraphPoint[] points) {
        if (points == null) {
            throw new java.lang.NullPointerException("Field 'points' cannot be null.");
            
        }
        this.commutatorUuid = commutatorUuid;
        this.deviceId = deviceId;
        this.deviceName = deviceName;
        this.unit = unit;
        this.points = points;
        
    }
    public String getCommutatorUuid() {
        return this.commutatorUuid;
        
    }
    public int getDeviceId() {
        return this.deviceId;
        
    }
    public String getDeviceName() {
        return this.deviceName;
        
    }
    public String getUnit() {
        return this.unit;
        
    }
    public GraphPoint[] getPoints() {
        return this.points;
        
    }
    public boolean pointsContains(GraphPoint el) {
        return ObjectSet.of(this.points).contains(el);
        
    }
    @Override public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || !(o instanceof SensorHistorySeries)) return false;
        SensorHistorySeries that = (SensorHistorySeries) o;
        return java.util.Objects.equals(this.commutatorUuid, that.commutatorUuid) && java.util.Objects.equals(this.deviceId, that.deviceId) && java.util.Objects.equals(this.deviceName, that.deviceName) && java.util.Objects.equals(this.unit, that.unit) && java.util.Arrays.equals(this.points, that.points);
        
    }
    @Override public int hashCode() {
        return java.util.Objects.hash(this.commutatorUuid, this.deviceId, this.deviceName, this.unit, java.util.Arrays.hashCode(this.points));
        
    }
    @Override public String toString() {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb) {
        sb.add("SensorHistorySeries(");
        sb.add("commutatorUuid:");
        sb.add(this.commutatorUuid);
        sb.add(", ");
        sb.add("deviceId:");
        sb.add(this.deviceId);
        sb.add(", ");
        sb.add("deviceName:");
        sb.add(this.deviceName);
        sb.add(", ");
        sb.add("unit:");
        sb.add(this.unit);
        sb.add(", ");
        sb.add("points:");
        sb.add(this.points);
        sb.add(')');
        
    }
    
}