/*
 * Decompiled with CFR 0.152.
 */
package io.aether.api.smarthome.gui.state;

import io.aether.api.smarthome.gui.state.KnownCommutator;
import io.aether.api.smarthome.gui.state.MetricPoint;
import io.aether.api.smarthome.gui.state.SensorHistorySeries;
import io.aether.net.fastMeta.DeserializerPackNumber;
import io.aether.net.fastMeta.FastFutureContext;
import io.aether.net.fastMeta.FastMetaType;
import io.aether.net.fastMeta.MNullable;
import io.aether.net.fastMeta.SerializerPackNumber;
import io.aether.utils.AString;
import io.aether.utils.ToString;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Arrays;
import java.util.Objects;

public class AppStateData
implements ToString {
    public static final FastMetaType<AppStateData> META_BODY = new FastMetaType<AppStateData>(){

        public void serialize(FastFutureContext serializeContextVar_64, AppStateData obj_65, DataOut out_66) {
            int _mask = 0;
            if (obj_65.targetCommutatorUuid == null) {
                _mask = (byte)(_mask | 1);
            }
            out_66.writeByte(_mask);
            out_66.writeInt(obj_65.pollingTimeoutMs);
            out_66.writeInt(obj_65.pollingBufferSize);
            out_66.writeInt(obj_65.targetDeviceId);
            if (obj_65.targetCommutatorUuid != null) {
                byte[] stringData_68 = obj_65.targetCommutatorUuid.getBytes();
                SerializerPackNumber.INSTANCE.put(out_66, stringData_68.length);
                out_66.write(stringData_68);
            }
            SerializerPackNumber.INSTANCE.put(out_66, obj_65.knownCommutators.length);
            for (KnownCommutator forVar_69 : obj_65.knownCommutators) {
                KnownCommutator.META.serialize(serializeContextVar_64, (Object)forVar_69, out_66);
            }
            SerializerPackNumber.INSTANCE.put(out_66, obj_65.sensorHistory.length);
            for (SensorHistorySeries forVar_70 : obj_65.sensorHistory) {
                SensorHistorySeries.META.serialize(serializeContextVar_64, (Object)forVar_70, out_66);
            }
            SerializerPackNumber.INSTANCE.put(out_66, obj_65.rttMetrics.length);
            for (MetricPoint forVar_71 : obj_65.rttMetrics) {
                MetricPoint.META.serialize(serializeContextVar_64, (Object)forVar_71, out_66);
            }
            out_66.writeInt(obj_65.totalRequests);
            out_66.writeInt(obj_65.packetLossCount);
            SerializerPackNumber.INSTANCE.put(out_66, obj_65.visibleSensorKeys.length);
            for (String forVar_72 : obj_65.visibleSensorKeys) {
                byte[] stringData_73 = forVar_72.getBytes();
                SerializerPackNumber.INSTANCE.put(out_66, stringData_73.length);
                out_66.write(stringData_73);
            }
        }

        public AppStateData deserialize(FastFutureContext serializeContextVar_64, DataIn in_67) {
            String targetCommutatorUuid_77;
            byte _mask = in_67.readByte();
            int pollingTimeoutMs_74 = in_67.readInt();
            int pollingBufferSize_75 = in_67.readInt();
            int targetDeviceId_76 = in_67.readInt();
            if ((_mask & 1) == 0) {
                int arraySize_85 = DeserializerPackNumber.INSTANCE.put(in_67).intValue();
                byte[] stringData_84 = new byte[arraySize_85];
                in_67.read(stringData_84);
                targetCommutatorUuid_77 = new String(stringData_84);
            } else {
                targetCommutatorUuid_77 = null;
            }
            int arraySize_86 = DeserializerPackNumber.INSTANCE.put(in_67).intValue();
            KnownCommutator[] knownCommutators_78 = new KnownCommutator[arraySize_86];
            for (int forVar_87 = 0; forVar_87 < arraySize_86; ++forVar_87) {
                knownCommutators_78[forVar_87] = (KnownCommutator)KnownCommutator.META.deserialize(serializeContextVar_64, in_67);
            }
            int arraySize_88 = DeserializerPackNumber.INSTANCE.put(in_67).intValue();
            SensorHistorySeries[] sensorHistory_79 = new SensorHistorySeries[arraySize_88];
            for (int forVar_89 = 0; forVar_89 < arraySize_88; ++forVar_89) {
                sensorHistory_79[forVar_89] = (SensorHistorySeries)SensorHistorySeries.META.deserialize(serializeContextVar_64, in_67);
            }
            int arraySize_90 = DeserializerPackNumber.INSTANCE.put(in_67).intValue();
            MetricPoint[] rttMetrics_80 = new MetricPoint[arraySize_90];
            for (int forVar_91 = 0; forVar_91 < arraySize_90; ++forVar_91) {
                rttMetrics_80[forVar_91] = (MetricPoint)MetricPoint.META.deserialize(serializeContextVar_64, in_67);
            }
            int totalRequests_81 = in_67.readInt();
            int packetLossCount_82 = in_67.readInt();
            int arraySize_92 = DeserializerPackNumber.INSTANCE.put(in_67).intValue();
            String[] visibleSensorKeys_83 = new String[arraySize_92];
            for (int forVar_93 = 0; forVar_93 < arraySize_92; ++forVar_93) {
                int arraySize_95 = DeserializerPackNumber.INSTANCE.put(in_67).intValue();
                byte[] stringData_94 = new byte[arraySize_95];
                in_67.read(stringData_94);
                visibleSensorKeys_83[forVar_93] = new String(stringData_94);
            }
            return new AppStateData(pollingTimeoutMs_74, pollingBufferSize_75, targetDeviceId_76, targetCommutatorUuid_77, knownCommutators_78, sensorHistory_79, rttMetrics_80, totalRequests_81, packetLossCount_82, visibleSensorKeys_83);
        }
    };
    public static final FastMetaType<AppStateData> META = new FastMetaType<AppStateData>(){

        public void serialize(FastFutureContext serializeContextVar_96, AppStateData obj_97, DataOut out_98) {
            META_BODY.serialize(serializeContextVar_96, (Object)obj_97, out_98);
        }

        public AppStateData deserialize(FastFutureContext serializeContextVar_96, DataIn in_99) {
            return (AppStateData)META_BODY.deserialize(serializeContextVar_96, in_99);
        }
    };
    protected final int pollingTimeoutMs;
    protected final int pollingBufferSize;
    protected final int targetDeviceId;
    @MNullable
    protected final String targetCommutatorUuid;
    protected final KnownCommutator[] knownCommutators;
    protected final SensorHistorySeries[] sensorHistory;
    protected final MetricPoint[] rttMetrics;
    protected final int totalRequests;
    protected final int packetLossCount;
    protected final String[] visibleSensorKeys;

    public AppStateData(int pollingTimeoutMs, int pollingBufferSize, int targetDeviceId, String targetCommutatorUuid, KnownCommutator[] knownCommutators, SensorHistorySeries[] sensorHistory, MetricPoint[] rttMetrics, int totalRequests, int packetLossCount, String[] visibleSensorKeys) {
        if (knownCommutators == null) {
            throw new NullPointerException("Field 'knownCommutators' cannot be null.");
        }
        if (sensorHistory == null) {
            throw new NullPointerException("Field 'sensorHistory' cannot be null.");
        }
        if (rttMetrics == null) {
            throw new NullPointerException("Field 'rttMetrics' cannot be null.");
        }
        if (visibleSensorKeys == null) {
            throw new NullPointerException("Field 'visibleSensorKeys' cannot be null.");
        }
        this.pollingTimeoutMs = pollingTimeoutMs;
        this.pollingBufferSize = pollingBufferSize;
        this.targetDeviceId = targetDeviceId;
        this.targetCommutatorUuid = targetCommutatorUuid;
        this.knownCommutators = knownCommutators;
        this.sensorHistory = sensorHistory;
        this.rttMetrics = rttMetrics;
        this.totalRequests = totalRequests;
        this.packetLossCount = packetLossCount;
        this.visibleSensorKeys = visibleSensorKeys;
    }

    public int getPollingTimeoutMs() {
        return this.pollingTimeoutMs;
    }

    public int getPollingBufferSize() {
        return this.pollingBufferSize;
    }

    public int getTargetDeviceId() {
        return this.targetDeviceId;
    }

    public String getTargetCommutatorUuid() {
        return this.targetCommutatorUuid;
    }

    public KnownCommutator[] getKnownCommutators() {
        return this.knownCommutators;
    }

    public boolean knownCommutatorsContains(KnownCommutator el) {
        return ObjectSet.of((Object[])this.knownCommutators).contains((Object)el);
    }

    public SensorHistorySeries[] getSensorHistory() {
        return this.sensorHistory;
    }

    public boolean sensorHistoryContains(SensorHistorySeries el) {
        return ObjectSet.of((Object[])this.sensorHistory).contains((Object)el);
    }

    public MetricPoint[] getRttMetrics() {
        return this.rttMetrics;
    }

    public boolean rttMetricsContains(MetricPoint el) {
        return ObjectSet.of((Object[])this.rttMetrics).contains((Object)el);
    }

    public int getTotalRequests() {
        return this.totalRequests;
    }

    public int getPacketLossCount() {
        return this.packetLossCount;
    }

    public String[] getVisibleSensorKeys() {
        return this.visibleSensorKeys;
    }

    public boolean visibleSensorKeysContains(String el) {
        return ObjectSet.of((Object[])this.visibleSensorKeys).contains((Object)el);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof AppStateData)) {
            return false;
        }
        AppStateData that = (AppStateData)o;
        return Objects.equals(this.pollingTimeoutMs, that.pollingTimeoutMs) && Objects.equals(this.pollingBufferSize, that.pollingBufferSize) && Objects.equals(this.targetDeviceId, that.targetDeviceId) && Objects.equals(this.targetCommutatorUuid, that.targetCommutatorUuid) && Arrays.equals(this.knownCommutators, that.knownCommutators) && Arrays.equals(this.sensorHistory, that.sensorHistory) && Arrays.equals(this.rttMetrics, that.rttMetrics) && Objects.equals(this.totalRequests, that.totalRequests) && Objects.equals(this.packetLossCount, that.packetLossCount) && Arrays.equals(this.visibleSensorKeys, that.visibleSensorKeys);
    }

    public int hashCode() {
        return Objects.hash(this.pollingTimeoutMs, this.pollingBufferSize, this.targetDeviceId, this.targetCommutatorUuid, Arrays.hashCode(this.knownCommutators), Arrays.hashCode(this.sensorHistory), Arrays.hashCode(this.rttMetrics), this.totalRequests, this.packetLossCount, Arrays.hashCode(this.visibleSensorKeys));
    }

    public String toString() {
        return this.toString2();
    }

    public void toString(AString sb) {
        sb.add("AppStateData(");
        sb.add("pollingTimeoutMs:");
        sb.add(this.pollingTimeoutMs);
        sb.add(", ");
        sb.add("pollingBufferSize:");
        sb.add(this.pollingBufferSize);
        sb.add(", ");
        sb.add("targetDeviceId:");
        sb.add(this.targetDeviceId);
        sb.add(", ");
        sb.add("targetCommutatorUuid:");
        sb.add(this.targetCommutatorUuid);
        sb.add(", ");
        sb.add("knownCommutators:");
        sb.add((Object[])this.knownCommutators);
        sb.add(", ");
        sb.add("sensorHistory:");
        sb.add((Object[])this.sensorHistory);
        sb.add(", ");
        sb.add("rttMetrics:");
        sb.add((Object[])this.rttMetrics);
        sb.add(", ");
        sb.add("totalRequests:");
        sb.add(this.totalRequests);
        sb.add(", ");
        sb.add("packetLossCount:");
        sb.add(this.packetLossCount);
        sb.add(", ");
        sb.add("visibleSensorKeys:");
        sb.add((Object[])this.visibleSensorKeys);
        sb.add(')');
    }
}

