package io.aether.api.smarthome;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class DeviceStateData implements io.aether.utils.ToString {
    public static final FastMetaType<DeviceStateData> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_53, DeviceStateData obj_54, DataOut out_55) {
            VariantData.META.serialize(serializeContextVar_53,obj_54.payload,out_55);
            out_55.writeLong(obj_54.timestamp.getTime());
            
        }
        @Override public DeviceStateData deserialize(FastFutureContext serializeContextVar_53, DataIn in_56) {
            VariantData payload_57;
            java.util.Date timestamp_58;
            payload_57=VariantData.META.deserialize(serializeContextVar_53,in_56);
            timestamp_58=new java.util.Date(in_56.readLong());
            return new DeviceStateData(payload_57,timestamp_58);
            
        }
        
    };
    public static final FastMetaType<DeviceStateData> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_59, DeviceStateData obj_60, DataOut out_61) {
            DeviceStateData.META_BODY.serialize(serializeContextVar_59, obj_60, out_61);
            
        }
        @Override public DeviceStateData deserialize(FastFutureContext serializeContextVar_59, DataIn in_62) {
            return DeviceStateData.META_BODY.deserialize(serializeContextVar_59, in_62);
            
        }
        
    };
    protected final VariantData payload;
    protected final java.util.Date timestamp;
    public DeviceStateData(VariantData payload, java.util.Date timestamp) {
        if (payload == null) {
            throw new java.lang.NullPointerException("Field 'payload' cannot be null.");
            
        }
        this.payload = payload;
        this.timestamp = timestamp;
        
    }
    public VariantData getPayload() {
        return this.payload;
        
    }
    public java.util.Date getTimestamp() {
        return this.timestamp;
        
    }
    @Override public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || !(o instanceof DeviceStateData)) return false;
        DeviceStateData that = (DeviceStateData) o;
        return java.util.Objects.equals(this.payload, that.payload) && java.util.Objects.equals(this.timestamp, that.timestamp);
        
    }
    @Override public int hashCode() {
        return java.util.Objects.hash(this.payload, this.timestamp);
        
    }
    @Override public String toString() {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb) {
        sb.add("DeviceStateData(");
        sb.add("payload:");
        sb.add(this.payload);
        sb.add(", ");
        sb.add("timestamp:");
        sb.add(this.timestamp);
        sb.add(')');
        
    }
    
}