package io.aether.api.smarthome;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class HardwareActor extends HardwareDevice implements io.aether.utils.ToString {
    @Override public int getAetherTypeId() {
        return 2;
        
    }
    public static final FastMetaType<HardwareActor> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_84, HardwareActor obj_85, DataOut out_86) {
            out_86.writeInt(obj_85.localId);
            var stringData_88=obj_85.descriptor.getBytes();
            SerializerPackNumber.INSTANCE.put(out_86,stringData_88.length);
            out_86.write(stringData_88);
            
        }
        @Override public HardwareActor deserialize(FastFutureContext serializeContextVar_84, DataIn in_87) {
            int localId_89;
            String descriptor_90;
            localId_89=in_87.readInt();
            byte[] stringData_91;
            var arraySize_92 = DeserializerPackNumber.INSTANCE.put(in_87).intValue();
            stringData_91=new byte[arraySize_92];
            in_87.read(stringData_91);
            descriptor_90=new String(stringData_91);
            return new HardwareActor(localId_89,descriptor_90);
            
        }
        
    };
    public static final FastMetaType<HardwareActor> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_93, HardwareActor obj_94, DataOut out_95) {
            HardwareActor.META_BODY.serialize(serializeContextVar_93, obj_94, out_95);
            
        }
        @Override public HardwareActor deserialize(FastFutureContext serializeContextVar_93, DataIn in_96) {
            return HardwareActor.META_BODY.deserialize(serializeContextVar_93, in_96);
            
        }
        
    };
    public HardwareActor(int localId, String descriptor) {
        super(localId, descriptor);
        
    }
    @Override public String getHardwareType() {
        return "ACTOR";
        
    }
    @Override public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || !(o instanceof HardwareActor)) return false;
        HardwareActor that = (HardwareActor) o;
        return java.util.Objects.equals(this.localId, that.localId) && java.util.Objects.equals(this.descriptor, that.descriptor);
        
    }
    @Override public int hashCode() {
        return java.util.Objects.hash(this.localId, this.descriptor);
        
    }
    @Override public String toString() {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb) {
        sb.add("HardwareActor(");
        sb.add("localId:");
        sb.add(this.localId);
        sb.add(", ");
        sb.add("descriptor:");
        sb.add(this.descriptor);
        sb.add(", ");
        sb.add("hardwareType:");
        sb.add(this.getHardwareType());
        sb.add(')');
        
    }
    
}