package io.aether.api.smarthome;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public abstract class HardwareDevice implements io.aether.utils.ToString {
    public abstract int getAetherTypeId();
    public static final FastMetaType<HardwareDevice> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_63, HardwareDevice obj_64, DataOut out_65) {
            out_65.writeByte(obj_64.getAetherTypeId());
            switch(obj_64.getAetherTypeId()) {
                case 1: HardwareSensor.META_BODY.serialize(serializeContextVar_63, (HardwareSensor)obj_64, out_65);
                break;
                case 2: HardwareActor.META_BODY.serialize(serializeContextVar_63, (HardwareActor)obj_64, out_65);
                break;
                default: throw new java.lang.IllegalStateException("Cannot serialize 'HardwareDevice' with unknown type id " + obj_64.getAetherTypeId());
                
            }
            
        }
        @Override public HardwareDevice deserialize(FastFutureContext serializeContextVar_63, DataIn in_66) {
            var typeId = in_66.readUByte();
            switch(typeId) {
                case 1: return (HardwareDevice)HardwareSensor.META_BODY.deserialize(serializeContextVar_63,in_66);
                case 2: return (HardwareDevice)HardwareActor.META_BODY.deserialize(serializeContextVar_63,in_66);
                default: throw new java.lang.IllegalStateException("Bad type id "+typeId + " for type 'HardwareDevice'");
                
            }
            
        }
        
    };
    protected final int localId;
    protected final String descriptor;
    public HardwareDevice(int localId, String descriptor) {
        this.localId = localId;
        this.descriptor = descriptor;
        
    }
    public int getLocalId() {
        return this.localId;
        
    }
    public String getDescriptor() {
        return this.descriptor;
        
    }
    public abstract String getHardwareType();
    @Override public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || !(o instanceof HardwareDevice)) return false;
        HardwareDevice that = (HardwareDevice) o;
        return java.util.Objects.equals(this.localId, that.localId) && java.util.Objects.equals(this.descriptor, that.descriptor);
        
    }
    @Override public int hashCode() {
        return java.util.Objects.hash(this.localId, this.descriptor);
        
    }
    @Override public String toString() {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb) {
        sb.add("HardwareDevice(");
        sb.add("localId:");
        sb.add(this.localId);
        sb.add(", ");
        sb.add("descriptor:");
        sb.add(this.descriptor);
        sb.add(')');
        
    }
    
}