package io.aether.api.smarthome;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class HardwareSensor extends HardwareDevice implements io.aether.utils.ToString {
    @Override public int getAetherTypeId() {
        return 1;
        
    }
    public static final FastMetaType<HardwareSensor> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_67, HardwareSensor obj_68, DataOut out_69) {
            byte _mask = 0;
            if(obj_68.unit == null) _mask |= 1;
            out_69.writeByte(_mask);
            out_69.writeInt(obj_68.localId);
            var stringData_71=obj_68.descriptor.getBytes();
            SerializerPackNumber.INSTANCE.put(out_69,stringData_71.length);
            out_69.write(stringData_71);
            if(obj_68.unit != null) {
                var stringData_72=obj_68.unit.getBytes();
                SerializerPackNumber.INSTANCE.put(out_69,stringData_72.length);
                out_69.write(stringData_72);
                
            }
            
        }
        @Override public HardwareSensor deserialize(FastFutureContext serializeContextVar_67, DataIn in_70) {
            int localId_73;
            String descriptor_74;
            String unit_75;
            byte _mask = in_70.readByte();
            localId_73=in_70.readInt();
            byte[] stringData_76;
            var arraySize_77 = DeserializerPackNumber.INSTANCE.put(in_70).intValue();
            stringData_76=new byte[arraySize_77];
            in_70.read(stringData_76);
            descriptor_74=new String(stringData_76);
            if ((_mask & 1) == 0) {
                byte[] stringData_78;
                var arraySize_79 = DeserializerPackNumber.INSTANCE.put(in_70).intValue();
                stringData_78=new byte[arraySize_79];
                in_70.read(stringData_78);
                unit_75=new String(stringData_78);
                
            }
            else {
                unit_75 = null;
                
            }
            return new HardwareSensor(localId_73,descriptor_74,unit_75);
            
        }
        
    };
    public static final FastMetaType<HardwareSensor> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_80, HardwareSensor obj_81, DataOut out_82) {
            HardwareSensor.META_BODY.serialize(serializeContextVar_80, obj_81, out_82);
            
        }
        @Override public HardwareSensor deserialize(FastFutureContext serializeContextVar_80, DataIn in_83) {
            return HardwareSensor.META_BODY.deserialize(serializeContextVar_80, in_83);
            
        }
        
    };
    protected final @MNullable String unit;
    public HardwareSensor(int localId, String descriptor, String unit) {
        super(localId, descriptor);
        this.unit = unit;
        
    }
    public String getUnit() {
        return this.unit;
        
    }
    @Override public String getHardwareType() {
        return "SENSOR";
        
    }
    @Override public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || !(o instanceof HardwareSensor)) return false;
        HardwareSensor that = (HardwareSensor) o;
        return java.util.Objects.equals(this.localId, that.localId) && java.util.Objects.equals(this.descriptor, that.descriptor) && java.util.Objects.equals(this.unit, that.unit);
        
    }
    @Override public int hashCode() {
        return java.util.Objects.hash(this.localId, this.descriptor, this.unit);
        
    }
    @Override public String toString() {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb) {
        sb.add("HardwareSensor(");
        sb.add("localId:");
        sb.add(this.localId);
        sb.add(", ");
        sb.add("descriptor:");
        sb.add(this.descriptor);
        sb.add(", ");
        sb.add("unit:");
        sb.add(this.unit);
        sb.add(", ");
        sb.add("hardwareType:");
        sb.add(this.getHardwareType());
        sb.add(')');
        
    }
    
}