package io.aether.api.smarthome;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public interface SmartHomeClientApi {
    FastMetaApi<SmartHomeClientApi,SmartHomeClientApiRemote> META=new FastMetaApi<>() {
        public void makeLocal(FastFutureContext serializeContextVar_151, DataIn in_, SmartHomeClientApi localApi) {
            while(in_.isReadable()) {
                byte commandId = in_.readByte();
                switch(commandId) {
                    case 0: {
                        var requestId_152 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_151,in_);
                        var futureRec_153 = serializeContextVar_151.getFuture(requestId_152);
                        if(futureRec_153 != null) futureRec_153.onDone(in_);
                        break;
                        
                    }
                    case 1: {
                        var requestId_154 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_151,in_);
                        var futureRec_155 = serializeContextVar_151.getFuture(requestId_154);
                        if(futureRec_155 != null) futureRec_155.onError(in_);
                        break;
                        
                    }
                    case 3: {
                        int localDeviceId_157;
                        DeviceStateData state_158;
                        localDeviceId_157=in_.readInt();
                        state_158=DeviceStateData.META.deserialize(serializeContextVar_151,in_);
                        String[] argsNames_159 = new String[] {
                            "localDeviceId", "state"
                        };
                        Object[] argsValues_160 = new Object[] {
                            localDeviceId_157, state_158
                        };
                        serializeContextVar_151.invokeLocalMethodBefore("deviceStateUpdated", argsNames_159, argsValues_160);
                        localApi.deviceStateUpdated(localDeviceId_157,state_158);
                        serializeContextVar_151.invokeLocalMethodAfter("deviceStateUpdated", null, argsNames_159, argsValues_160);
                        break;
                        
                    }
                    default: throw new IllegalArgumentException("Unknown command ID: " + commandId);
                    
                }
                
            }
            
        }
        public SmartHomeClientApiRemote makeRemote(FastFutureContext localApi_162) {
            return new SmartHomeClientApiRemote() {
                @Override public void flush(AFuture sendFuture) {
                    localApi_162.flush(sendFuture);
                    
                }
                public io.aether.net.fastMeta.FastFutureContext getFastMetaContext() {
                    return localApi_162;
                    
                }
                @Override public @Command(3) void deviceStateUpdated(int localDeviceId, DeviceStateData state) {
                    var dataOut_163 = new DataInOut();
                    dataOut_163.writeByte(3);
                    String[] argsNames_165 = new String[] {
                        "localDeviceId", "state"
                    };
                    Object[] argsValues_166 = new Object[] {
                        localDeviceId, state
                    };
                    localApi_162.invokeRemoteMethodAfter("deviceStateUpdated", null, argsNames_165, argsValues_166);
                    dataOut_163.writeInt(localDeviceId);
                    DeviceStateData.META.serialize(localApi_162,state,dataOut_163);
                    localApi_162.sendToRemote(dataOut_163.toArray());
                    
                }
                
            };
            
        }
        
    };
    @Command(3) void deviceStateUpdated(int localDeviceId, DeviceStateData state);
    
}