package io.aether.api.smarthome;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public interface SmartHomeCommutatorApi {
    FastMetaApi<SmartHomeCommutatorApi,SmartHomeCommutatorApiRemote> META=new FastMetaApi<>() {
        public void makeLocal(FastFutureContext serializeContextVar_97, DataIn in_, SmartHomeCommutatorApi localApi) {
            while(in_.isReadable()) {
                byte commandId = in_.readByte();
                switch(commandId) {
                    case 0: {
                        var requestId_98 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_97,in_);
                        var futureRec_99 = serializeContextVar_97.getFuture(requestId_98);
                        if(futureRec_99 != null) futureRec_99.onDone(in_);
                        break;
                        
                    }
                    case 1: {
                        var requestId_100 = FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_97,in_);
                        var futureRec_101 = serializeContextVar_97.getFuture(requestId_100);
                        if(futureRec_101 != null) futureRec_101.onError(in_);
                        break;
                        
                    }
                    case 10: {
                        int requestId_102 = in_.readInt();
                        String[] argsNames_103 = new String[] {
                            
                        };
                        Object[] argsValues_104 = new Object[] {
                            
                        };
                        serializeContextVar_97.invokeLocalMethodBefore("getSystemStructure", argsNames_103, argsValues_104);
                        serializeContextVar_97.regLocalFuture();
                        var result_105 = localApi.getSystemStructure();
                        serializeContextVar_97.invokeLocalMethodAfter("getSystemStructure", result_105, argsNames_103, argsValues_104);
                        result_105.to((v_107)-> {
                            var data_106 = new DataInOut();
                            SerializerPackNumber.INSTANCE.put(data_106,v_107.length);
                            for(var forVar_108:v_107) {
                                HardwareDevice.META.serialize(serializeContextVar_97,forVar_108,data_106);
                                
                            }
                            serializeContextVar_97.sendResultToRemote(requestId_102,data_106.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 4: {
                        int requestId_109 = in_.readInt();
                        int localActorId_110;
                        VariantData command_111;
                        localActorId_110=in_.readInt();
                        command_111=VariantData.META.deserialize(serializeContextVar_97,in_);
                        String[] argsNames_112 = new String[] {
                            "localActorId", "command"
                        };
                        Object[] argsValues_113 = new Object[] {
                            localActorId_110, command_111
                        };
                        serializeContextVar_97.invokeLocalMethodBefore("executeActorCommand", argsNames_112, argsValues_113);
                        serializeContextVar_97.regLocalFuture();
                        var result_114 = localApi.executeActorCommand(localActorId_110,command_111);
                        serializeContextVar_97.invokeLocalMethodAfter("executeActorCommand", result_114, argsNames_112, argsValues_113);
                        result_114.to((v_116)-> {
                            var data_115 = new DataInOut();
                            DeviceStateData.META.serialize(serializeContextVar_97,v_116,data_115);
                            serializeContextVar_97.sendResultToRemote(requestId_109,data_115.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 5: {
                        int requestId_117 = in_.readInt();
                        int localDeviceId_118;
                        localDeviceId_118=in_.readInt();
                        String[] argsNames_119 = new String[] {
                            "localDeviceId"
                        };
                        Object[] argsValues_120 = new Object[] {
                            localDeviceId_118
                        };
                        serializeContextVar_97.invokeLocalMethodBefore("queryState", argsNames_119, argsValues_120);
                        serializeContextVar_97.regLocalFuture();
                        var result_121 = localApi.queryState(localDeviceId_118);
                        serializeContextVar_97.invokeLocalMethodAfter("queryState", result_121, argsNames_119, argsValues_120);
                        result_121.to((v_123)-> {
                            var data_122 = new DataInOut();
                            DeviceStateData.META.serialize(serializeContextVar_97,v_123,data_122);
                            serializeContextVar_97.sendResultToRemote(requestId_117,data_122.toArray());
                            
                        }
                        );
                        break;
                        
                    }
                    case 6: {
                        String[] argsNames_125 = new String[] {
                            
                        };
                        Object[] argsValues_126 = new Object[] {
                            
                        };
                        serializeContextVar_97.invokeLocalMethodBefore("queryAllSensorStates", argsNames_125, argsValues_126);
                        localApi.queryAllSensorStates();
                        serializeContextVar_97.invokeLocalMethodAfter("queryAllSensorStates", null, argsNames_125, argsValues_126);
                        break;
                        
                    }
                    default: throw new IllegalArgumentException("Unknown command ID: " + commandId);
                    
                }
                
            }
            
        }
        public SmartHomeCommutatorApiRemote makeRemote(FastFutureContext localApi_128) {
            return new SmartHomeCommutatorApiRemote() {
                @Override public void flush(AFuture sendFuture) {
                    localApi_128.flush(sendFuture);
                    
                }
                public io.aether.net.fastMeta.FastFutureContext getFastMetaContext() {
                    return localApi_128;
                    
                }
                @Override public @Command(10) ARFuture<HardwareDevice[]> getSystemStructure() {
                    var dataOut_129 = new DataInOut();
                    dataOut_129.writeByte(10);
                    String[] argsNames_131 = new String[] {
                        
                    };
                    Object[] argsValues_132 = new Object[] {
                        
                    };
                    var result_130 = ARFuture.<HardwareDevice[]>make();
                    localApi_128.invokeRemoteMethodAfter("getSystemStructure", result_130, argsNames_131, argsValues_132);
                    var requestId_133 = localApi_128.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_130.done(SmarthomeMeta.META_ARRAY_HardwareDevice.deserialize(localApi_128,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_130.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_129.writeInt(requestId_133);
                    localApi_128.sendToRemote(dataOut_129.toArray());
                    return result_130;
                    
                }
                @Override public @Command(4) ARFuture<DeviceStateData> executeActorCommand(int localActorId, VariantData command) {
                    var dataOut_137 = new DataInOut();
                    dataOut_137.writeByte(4);
                    String[] argsNames_139 = new String[] {
                        "localActorId", "command"
                    };
                    Object[] argsValues_140 = new Object[] {
                        localActorId, command
                    };
                    var result_138 = ARFuture.<DeviceStateData>make();
                    localApi_128.invokeRemoteMethodAfter("executeActorCommand", result_138, argsNames_139, argsValues_140);
                    var requestId_141 = localApi_128.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_138.done(DeviceStateData.META.deserialize(localApi_128,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_138.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_137.writeInt(requestId_141);
                    dataOut_137.writeInt(localActorId);
                    VariantData.META.serialize(localApi_128,command,dataOut_137);
                    localApi_128.sendToRemote(dataOut_137.toArray());
                    return result_138;
                    
                }
                @Override public @Command(5) ARFuture<DeviceStateData> queryState(int localDeviceId) {
                    var dataOut_142 = new DataInOut();
                    dataOut_142.writeByte(5);
                    String[] argsNames_144 = new String[] {
                        "localDeviceId"
                    };
                    Object[] argsValues_145 = new Object[] {
                        localDeviceId
                    };
                    var result_143 = ARFuture.<DeviceStateData>make();
                    localApi_128.invokeRemoteMethodAfter("queryState", result_143, argsNames_144, argsValues_145);
                    var requestId_146 = localApi_128.regFuture(new FutureRec() {
                        public void onDone(DataIn in) {
                            result_143.done(DeviceStateData.META.deserialize(localApi_128,in));
                            
                        }
                        public void onError(DataIn in) {
                            result_143.error(new AetherException("Remote call failed without a typed exception"));
                            
                        }
                        
                    }
                    );
                    dataOut_142.writeInt(requestId_146);
                    dataOut_142.writeInt(localDeviceId);
                    localApi_128.sendToRemote(dataOut_142.toArray());
                    return result_143;
                    
                }
                @Override public @Command(6) void queryAllSensorStates() {
                    var dataOut_147 = new DataInOut();
                    dataOut_147.writeByte(6);
                    String[] argsNames_149 = new String[] {
                        
                    };
                    Object[] argsValues_150 = new Object[] {
                        
                    };
                    localApi_128.invokeRemoteMethodAfter("queryAllSensorStates", null, argsNames_149, argsValues_150);
                    localApi_128.sendToRemote(dataOut_147.toArray());
                    
                }
                
            };
            
        }
        
    };
    @Command(10) ARFuture<HardwareDevice[]> getSystemStructure();
    @Command(4) ARFuture<DeviceStateData> executeActorCommand(int localActorId, VariantData command);
    @Command(5) ARFuture<DeviceStateData> queryState(int localDeviceId);
    @Command(6) void queryAllSensorStates();
    
}