package io.aether.api.smarthome;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class VariantBytes extends VariantData implements io.aether.utils.ToString {
    @Override public int getAetherTypeId() {
        return 5;
        
    }
    public static final FastMetaType<VariantBytes> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_43, VariantBytes obj_44, DataOut out_45) {
            SerializerPackNumber.INSTANCE.put(out_45,obj_44.value.length);
            out_45.write(obj_44.value);
            
        }
        @Override public VariantBytes deserialize(FastFutureContext serializeContextVar_43, DataIn in_46) {
            byte[] value_47;
            var arraySize_48 = DeserializerPackNumber.INSTANCE.put(in_46).intValue();
            value_47=new byte[arraySize_48];
            in_46.read(value_47);
            return new VariantBytes(value_47);
            
        }
        
    };
    public static final FastMetaType<VariantBytes> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_49, VariantBytes obj_50, DataOut out_51) {
            VariantBytes.META_BODY.serialize(serializeContextVar_49, obj_50, out_51);
            
        }
        @Override public VariantBytes deserialize(FastFutureContext serializeContextVar_49, DataIn in_52) {
            return VariantBytes.META_BODY.deserialize(serializeContextVar_49, in_52);
            
        }
        
    };
    protected final byte[] value;
    public VariantBytes(byte[] value) {
        if (value == null) {
            throw new java.lang.NullPointerException("Field 'value' cannot be null.");
            
        }
        this.value = value;
        
    }
    public byte[] getValue() {
        return this.value;
        
    }
    public boolean valueContains(byte el) {
        return ByteSet.of(this.value).contains(el);
        
    }
    @Override public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || !(o instanceof VariantBytes)) return false;
        VariantBytes that = (VariantBytes) o;
        return java.util.Arrays.equals(this.value, that.value);
        
    }
    @Override public int hashCode() {
        return java.util.Objects.hash(java.util.Arrays.hashCode(this.value));
        
    }
    @Override public String toString() {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb) {
        sb.add("VariantBytes(");
        sb.add("value:");
        sb.add(this.value);
        sb.add(')');
        
    }
    
}