package io.aether.api.smarthome;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public abstract class VariantData implements io.aether.utils.ToString {
    public abstract int getAetherTypeId();
    public static final FastMetaType<VariantData> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_0, VariantData obj_1, DataOut out_2) {
            out_2.writeByte(obj_1.getAetherTypeId());
            switch(obj_1.getAetherTypeId()) {
                case 1: VariantBool.META_BODY.serialize(serializeContextVar_0, (VariantBool)obj_1, out_2);
                break;
                case 2: VariantLong.META_BODY.serialize(serializeContextVar_0, (VariantLong)obj_1, out_2);
                break;
                case 3: VariantDouble.META_BODY.serialize(serializeContextVar_0, (VariantDouble)obj_1, out_2);
                break;
                case 4: VariantString.META_BODY.serialize(serializeContextVar_0, (VariantString)obj_1, out_2);
                break;
                case 5: VariantBytes.META_BODY.serialize(serializeContextVar_0, (VariantBytes)obj_1, out_2);
                break;
                default: throw new java.lang.IllegalStateException("Cannot serialize 'VariantData' with unknown type id " + obj_1.getAetherTypeId());
                
            }
            
        }
        @Override public VariantData deserialize(FastFutureContext serializeContextVar_0, DataIn in_3) {
            var typeId = in_3.readUByte();
            switch(typeId) {
                case 1: return (VariantData)VariantBool.META_BODY.deserialize(serializeContextVar_0,in_3);
                case 2: return (VariantData)VariantLong.META_BODY.deserialize(serializeContextVar_0,in_3);
                case 3: return (VariantData)VariantDouble.META_BODY.deserialize(serializeContextVar_0,in_3);
                case 4: return (VariantData)VariantString.META_BODY.deserialize(serializeContextVar_0,in_3);
                case 5: return (VariantData)VariantBytes.META_BODY.deserialize(serializeContextVar_0,in_3);
                default: throw new java.lang.IllegalStateException("Bad type id "+typeId + " for type 'VariantData'");
                
            }
            
        }
        
    };
    public VariantData() {
        
    }
    @Override public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || !(o instanceof VariantData)) return false;
        VariantData that = (VariantData) o;
        return true;
        
    }
    @Override public int hashCode() {
        return 0;
        
    }
    @Override public String toString() {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb) {
        sb.add("VariantData(");
        sb.add(')');
        
    }
    
}