package io.aether.api.smarthome;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class VariantString extends VariantData implements io.aether.utils.ToString {
    @Override public int getAetherTypeId() {
        return 4;
        
    }
    public static final FastMetaType<VariantString> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_31, VariantString obj_32, DataOut out_33) {
            var stringData_35=obj_32.value.getBytes();
            SerializerPackNumber.INSTANCE.put(out_33,stringData_35.length);
            out_33.write(stringData_35);
            
        }
        @Override public VariantString deserialize(FastFutureContext serializeContextVar_31, DataIn in_34) {
            String value_36;
            byte[] stringData_37;
            var arraySize_38 = DeserializerPackNumber.INSTANCE.put(in_34).intValue();
            stringData_37=new byte[arraySize_38];
            in_34.read(stringData_37);
            value_36=new String(stringData_37);
            return new VariantString(value_36);
            
        }
        
    };
    public static final FastMetaType<VariantString> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_39, VariantString obj_40, DataOut out_41) {
            VariantString.META_BODY.serialize(serializeContextVar_39, obj_40, out_41);
            
        }
        @Override public VariantString deserialize(FastFutureContext serializeContextVar_39, DataIn in_42) {
            return VariantString.META_BODY.deserialize(serializeContextVar_39, in_42);
            
        }
        
    };
    protected final String value;
    public VariantString(String value) {
        this.value = value;
        
    }
    public String getValue() {
        return this.value;
        
    }
    @Override public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || !(o instanceof VariantString)) return false;
        VariantString that = (VariantString) o;
        return java.util.Objects.equals(this.value, that.value);
        
    }
    @Override public int hashCode() {
        return java.util.Objects.hash(this.value);
        
    }
    @Override public String toString() {
        return toString2();
        
    }
    @Override public void toString(io.aether.utils.AString sb) {
        sb.add("VariantString(");
        sb.add("value:");
        sb.add(this.value);
        sb.add(')');
        
    }
    
}