/*
 * Decompiled with CFR 0.152.
 */
package io.aether.api.smarthome;

import io.aether.api.smarthome.HardwareActor;
import io.aether.api.smarthome.HardwareSensor;
import io.aether.net.fastMeta.FastFutureContext;
import io.aether.net.fastMeta.FastMetaType;
import io.aether.utils.AString;
import io.aether.utils.ToString;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import java.util.Objects;

public abstract class HardwareDevice
implements ToString {
    public static final FastMetaType<HardwareDevice> META = new FastMetaType<HardwareDevice>(){

        public void serialize(FastFutureContext serializeContextVar_63, HardwareDevice obj_64, DataOut out_65) {
            out_65.writeByte(obj_64.getAetherTypeId());
            switch (obj_64.getAetherTypeId()) {
                case 1: {
                    HardwareSensor.META_BODY.serialize(serializeContextVar_63, (Object)((HardwareSensor)obj_64), out_65);
                    break;
                }
                case 2: {
                    HardwareActor.META_BODY.serialize(serializeContextVar_63, (Object)((HardwareActor)obj_64), out_65);
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot serialize 'HardwareDevice' with unknown type id " + obj_64.getAetherTypeId());
                }
            }
        }

        public HardwareDevice deserialize(FastFutureContext serializeContextVar_63, DataIn in_66) {
            int typeId = in_66.readUByte();
            switch (typeId) {
                case 1: {
                    return (HardwareDevice)HardwareSensor.META_BODY.deserialize(serializeContextVar_63, in_66);
                }
                case 2: {
                    return (HardwareDevice)HardwareActor.META_BODY.deserialize(serializeContextVar_63, in_66);
                }
            }
            throw new IllegalStateException("Bad type id " + typeId + " for type 'HardwareDevice'");
        }
    };
    protected final int localId;
    protected final String descriptor;

    public abstract int getAetherTypeId();

    public HardwareDevice(int localId, String descriptor) {
        this.localId = localId;
        this.descriptor = descriptor;
    }

    public int getLocalId() {
        return this.localId;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public abstract String getHardwareType();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof HardwareDevice)) {
            return false;
        }
        HardwareDevice that = (HardwareDevice)o;
        return Objects.equals(this.localId, that.localId) && Objects.equals(this.descriptor, that.descriptor);
    }

    public int hashCode() {
        return Objects.hash(this.localId, this.descriptor);
    }

    public String toString() {
        return this.toString2();
    }

    public void toString(AString sb) {
        sb.add("HardwareDevice(");
        sb.add("localId:");
        sb.add(this.localId);
        sb.add(", ");
        sb.add("descriptor:");
        sb.add(this.descriptor);
        sb.add(')');
    }
}

