/*
 * Decompiled with CFR 0.152.
 */
package io.aether.api.smarthome;

import io.aether.api.smarthome.DeviceStateData;
import io.aether.api.smarthome.SmartHomeClientApiRemote;
import io.aether.net.fastMeta.Command;
import io.aether.net.fastMeta.FastFutureContext;
import io.aether.net.fastMeta.FastMeta;
import io.aether.net.fastMeta.FastMetaApi;
import io.aether.net.fastMeta.FutureRec;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataInOut;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.futures.AFuture;
import java.util.Objects;

public interface SmartHomeClientApi {
    public static final FastMetaApi<SmartHomeClientApi, SmartHomeClientApiRemote> META = new FastMetaApi<SmartHomeClientApi, SmartHomeClientApiRemote>(){

        public void makeLocal(FastFutureContext serializeContextVar_151, DataIn in_, SmartHomeClientApi localApi) {
            block5: while (in_.isReadable()) {
                byte commandId = in_.readByte();
                switch (commandId) {
                    case 0: {
                        Integer requestId_152 = (Integer)FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_151, in_);
                        FutureRec futureRec_153 = serializeContextVar_151.getFuture(requestId_152.intValue());
                        if (futureRec_153 == null) continue block5;
                        futureRec_153.onDone(in_);
                        continue block5;
                    }
                    case 1: {
                        Integer requestId_154 = (Integer)FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_151, in_);
                        FutureRec futureRec_155 = serializeContextVar_151.getFuture(requestId_154.intValue());
                        if (futureRec_155 == null) continue block5;
                        futureRec_155.onError(in_);
                        continue block5;
                    }
                    case 3: {
                        int localDeviceId_157 = in_.readInt();
                        DeviceStateData state_158 = (DeviceStateData)DeviceStateData.META.deserialize(serializeContextVar_151, in_);
                        String[] argsNames_159 = new String[]{"localDeviceId", "state"};
                        Object[] argsValues_160 = new Object[]{localDeviceId_157, state_158};
                        serializeContextVar_151.invokeLocalMethodBefore("deviceStateUpdated", argsNames_159, argsValues_160);
                        localApi.deviceStateUpdated(localDeviceId_157, state_158);
                        serializeContextVar_151.invokeLocalMethodAfter("deviceStateUpdated", null, argsNames_159, argsValues_160);
                        continue block5;
                    }
                }
                throw new IllegalArgumentException("Unknown command ID: " + commandId);
            }
        }

        public SmartHomeClientApiRemote makeRemote(final FastFutureContext localApi_162) {
            return new SmartHomeClientApiRemote(){
                {
                    Objects.requireNonNull(this$0);
                }

                public void flush(AFuture sendFuture) {
                    localApi_162.flush(sendFuture);
                }

                public FastFutureContext getFastMetaContext() {
                    return localApi_162;
                }

                @Override
                @Command(value=3)
                public void deviceStateUpdated(int localDeviceId, DeviceStateData state) {
                    DataInOut dataOut_163 = new DataInOut();
                    dataOut_163.writeByte(3);
                    String[] argsNames_165 = new String[]{"localDeviceId", "state"};
                    Object[] argsValues_166 = new Object[]{localDeviceId, state};
                    localApi_162.invokeRemoteMethodAfter("deviceStateUpdated", null, argsNames_165, argsValues_166);
                    dataOut_163.writeInt(localDeviceId);
                    DeviceStateData.META.serialize(localApi_162, (Object)state, (DataOut)dataOut_163);
                    localApi_162.sendToRemote(dataOut_163.toArray());
                }
            };
        }
    };

    @Command(value=3)
    public void deviceStateUpdated(int var1, DeviceStateData var2);
}

