/*
 * Decompiled with CFR 0.152.
 */
package io.aether.api.smarthome;

import io.aether.api.smarthome.DeviceStateData;
import io.aether.api.smarthome.HardwareDevice;
import io.aether.api.smarthome.SmartHomeCommutatorApiRemote;
import io.aether.api.smarthome.SmarthomeMeta;
import io.aether.api.smarthome.VariantData;
import io.aether.net.fastMeta.AetherException;
import io.aether.net.fastMeta.Command;
import io.aether.net.fastMeta.FastFutureContext;
import io.aether.net.fastMeta.FastMeta;
import io.aether.net.fastMeta.FastMetaApi;
import io.aether.net.fastMeta.FutureRec;
import io.aether.net.fastMeta.SerializerPackNumber;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataInOut;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.AFutureBase;
import io.aether.utils.futures.ARFuture;
import java.util.Objects;

public interface SmartHomeCommutatorApi {
    public static final FastMetaApi<SmartHomeCommutatorApi, SmartHomeCommutatorApiRemote> META = new FastMetaApi<SmartHomeCommutatorApi, SmartHomeCommutatorApiRemote>(){

        public void makeLocal(FastFutureContext serializeContextVar_97, DataIn in_, SmartHomeCommutatorApi localApi) {
            block8: while (in_.isReadable()) {
                byte commandId = in_.readByte();
                switch (commandId) {
                    case 0: {
                        Integer requestId_98 = (Integer)FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_97, in_);
                        FutureRec futureRec_99 = serializeContextVar_97.getFuture(requestId_98.intValue());
                        if (futureRec_99 == null) continue block8;
                        futureRec_99.onDone(in_);
                        continue block8;
                    }
                    case 1: {
                        Integer requestId_100 = (Integer)FastMeta.META_REQUEST_ID.deserialize(serializeContextVar_97, in_);
                        FutureRec futureRec_101 = serializeContextVar_97.getFuture(requestId_100.intValue());
                        if (futureRec_101 == null) continue block8;
                        futureRec_101.onError(in_);
                        continue block8;
                    }
                    case 10: {
                        int requestId_102 = in_.readInt();
                        String[] argsNames_103 = new String[]{};
                        Object[] argsValues_104 = new Object[]{};
                        serializeContextVar_97.invokeLocalMethodBefore("getSystemStructure", argsNames_103, argsValues_104);
                        serializeContextVar_97.regLocalFuture();
                        ARFuture<HardwareDevice[]> result_105 = localApi.getSystemStructure();
                        serializeContextVar_97.invokeLocalMethodAfter("getSystemStructure", result_105, argsNames_103, argsValues_104);
                        result_105.to(v_107 -> {
                            DataInOut data_106 = new DataInOut();
                            SerializerPackNumber.INSTANCE.put((DataOut)data_106, ((HardwareDevice[])v_107).length);
                            for (HardwareDevice forVar_108 : v_107) {
                                HardwareDevice.META.serialize(serializeContextVar_97, (Object)forVar_108, (DataOut)data_106);
                            }
                            serializeContextVar_97.sendResultToRemote(requestId_102, data_106.toArray());
                        });
                        continue block8;
                    }
                    case 4: {
                        int requestId_109 = in_.readInt();
                        int localActorId_110 = in_.readInt();
                        VariantData command_111 = (VariantData)VariantData.META.deserialize(serializeContextVar_97, in_);
                        String[] argsNames_112 = new String[]{"localActorId", "command"};
                        Object[] argsValues_113 = new Object[]{localActorId_110, command_111};
                        serializeContextVar_97.invokeLocalMethodBefore("executeActorCommand", argsNames_112, argsValues_113);
                        serializeContextVar_97.regLocalFuture();
                        ARFuture<DeviceStateData> result_114 = localApi.executeActorCommand(localActorId_110, command_111);
                        serializeContextVar_97.invokeLocalMethodAfter("executeActorCommand", result_114, argsNames_112, argsValues_113);
                        result_114.to(v_116 -> {
                            DataInOut data_115 = new DataInOut();
                            DeviceStateData.META.serialize(serializeContextVar_97, v_116, (DataOut)data_115);
                            serializeContextVar_97.sendResultToRemote(requestId_109, data_115.toArray());
                        });
                        continue block8;
                    }
                    case 5: {
                        int requestId_117 = in_.readInt();
                        int localDeviceId_118 = in_.readInt();
                        String[] argsNames_119 = new String[]{"localDeviceId"};
                        Object[] argsValues_120 = new Object[]{localDeviceId_118};
                        serializeContextVar_97.invokeLocalMethodBefore("queryState", argsNames_119, argsValues_120);
                        serializeContextVar_97.regLocalFuture();
                        ARFuture<DeviceStateData> result_121 = localApi.queryState(localDeviceId_118);
                        serializeContextVar_97.invokeLocalMethodAfter("queryState", result_121, argsNames_119, argsValues_120);
                        result_121.to(v_123 -> {
                            DataInOut data_122 = new DataInOut();
                            DeviceStateData.META.serialize(serializeContextVar_97, v_123, (DataOut)data_122);
                            serializeContextVar_97.sendResultToRemote(requestId_117, data_122.toArray());
                        });
                        continue block8;
                    }
                    case 6: {
                        String[] argsNames_125 = new String[]{};
                        Object[] argsValues_126 = new Object[]{};
                        serializeContextVar_97.invokeLocalMethodBefore("queryAllSensorStates", argsNames_125, argsValues_126);
                        localApi.queryAllSensorStates();
                        serializeContextVar_97.invokeLocalMethodAfter("queryAllSensorStates", null, argsNames_125, argsValues_126);
                        continue block8;
                    }
                }
                throw new IllegalArgumentException("Unknown command ID: " + commandId);
            }
        }

        public SmartHomeCommutatorApiRemote makeRemote(final FastFutureContext localApi_128) {
            return new SmartHomeCommutatorApiRemote(){
                {
                    Objects.requireNonNull(this$0);
                }

                public void flush(AFuture sendFuture) {
                    localApi_128.flush(sendFuture);
                }

                public FastFutureContext getFastMetaContext() {
                    return localApi_128;
                }

                @Override
                @Command(value=10)
                public ARFuture<HardwareDevice[]> getSystemStructure() {
                    DataInOut dataOut_129 = new DataInOut();
                    dataOut_129.writeByte(10);
                    String[] argsNames_131 = new String[]{};
                    Object[] argsValues_132 = new Object[]{};
                    final ARFuture result_130 = ARFuture.make();
                    localApi_128.invokeRemoteMethodAfter("getSystemStructure", (AFutureBase)result_130, argsNames_131, argsValues_132);
                    int requestId_133 = localApi_128.regFuture(new FutureRec(){
                        {
                            Objects.requireNonNull(this$1);
                        }

                        public void onDone(DataIn in) {
                            result_130.done((Object)((HardwareDevice[])SmarthomeMeta.META_ARRAY_HardwareDevice.deserialize(localApi_128, in)));
                        }

                        public void onError(DataIn in) {
                            result_130.error((Throwable)new AetherException("Remote call failed without a typed exception"));
                        }
                    });
                    dataOut_129.writeInt(requestId_133);
                    localApi_128.sendToRemote(dataOut_129.toArray());
                    return result_130;
                }

                @Override
                @Command(value=4)
                public ARFuture<DeviceStateData> executeActorCommand(int localActorId, VariantData command) {
                    DataInOut dataOut_137 = new DataInOut();
                    dataOut_137.writeByte(4);
                    String[] argsNames_139 = new String[]{"localActorId", "command"};
                    Object[] argsValues_140 = new Object[]{localActorId, command};
                    final ARFuture result_138 = ARFuture.make();
                    localApi_128.invokeRemoteMethodAfter("executeActorCommand", (AFutureBase)result_138, argsNames_139, argsValues_140);
                    int requestId_141 = localApi_128.regFuture(new FutureRec(){
                        {
                            Objects.requireNonNull(this$1);
                        }

                        public void onDone(DataIn in) {
                            result_138.done((Object)((DeviceStateData)DeviceStateData.META.deserialize(localApi_128, in)));
                        }

                        public void onError(DataIn in) {
                            result_138.error((Throwable)new AetherException("Remote call failed without a typed exception"));
                        }
                    });
                    dataOut_137.writeInt(requestId_141);
                    dataOut_137.writeInt(localActorId);
                    VariantData.META.serialize(localApi_128, (Object)command, (DataOut)dataOut_137);
                    localApi_128.sendToRemote(dataOut_137.toArray());
                    return result_138;
                }

                @Override
                @Command(value=5)
                public ARFuture<DeviceStateData> queryState(int localDeviceId) {
                    DataInOut dataOut_142 = new DataInOut();
                    dataOut_142.writeByte(5);
                    String[] argsNames_144 = new String[]{"localDeviceId"};
                    Object[] argsValues_145 = new Object[]{localDeviceId};
                    final ARFuture result_143 = ARFuture.make();
                    localApi_128.invokeRemoteMethodAfter("queryState", (AFutureBase)result_143, argsNames_144, argsValues_145);
                    int requestId_146 = localApi_128.regFuture(new FutureRec(){
                        {
                            Objects.requireNonNull(this$1);
                        }

                        public void onDone(DataIn in) {
                            result_143.done((Object)((DeviceStateData)DeviceStateData.META.deserialize(localApi_128, in)));
                        }

                        public void onError(DataIn in) {
                            result_143.error((Throwable)new AetherException("Remote call failed without a typed exception"));
                        }
                    });
                    dataOut_142.writeInt(requestId_146);
                    dataOut_142.writeInt(localDeviceId);
                    localApi_128.sendToRemote(dataOut_142.toArray());
                    return result_143;
                }

                @Override
                @Command(value=6)
                public void queryAllSensorStates() {
                    DataInOut dataOut_147 = new DataInOut();
                    dataOut_147.writeByte(6);
                    String[] argsNames_149 = new String[]{};
                    Object[] argsValues_150 = new Object[]{};
                    localApi_128.invokeRemoteMethodAfter("queryAllSensorStates", null, argsNames_149, argsValues_150);
                    localApi_128.sendToRemote(dataOut_147.toArray());
                }
            };
        }
    };

    @Command(value=10)
    public ARFuture<HardwareDevice[]> getSystemStructure();

    @Command(value=4)
    public ARFuture<DeviceStateData> executeActorCommand(int var1, VariantData var2);

    @Command(value=5)
    public ARFuture<DeviceStateData> queryState(int var1);

    @Command(value=6)
    public void queryAllSensorStates();
}

