package io.aether.net.fastMeta;

import io.aether.utils.dataio.DataIn;

public class DeserializerPackNumber {
    public static final DeserializerPackNumber INSTANCE = new DeserializerPackNumber();
    private static final int u8 = 251;
    private static final int pow8_mask = 0xFF;
    private static final int pow8_shift = 8;
    private static final int pow8 = 256;
    private static final int k8ReservedFor16 = 16;
    private static final int k16ReservedFor32 = 256;
    private static final long pow32 = 4L * 1024 * 1024 * 1024;
    private static final int u16 = 5 * 256 + u8 - k8ReservedFor16;  // 1515
    private static final long u32 = 1024 * 1024 + u16 - k16ReservedFor32;  // 1 049 835
    private static final long u64 = u32 + pow32 * k16ReservedFor32;
    // maximum supported value is (1 Tb + 1 Mb + 1515 - 1)
    private static final int pow16_mask = 0xFFFF;
    private static final int pow16_shift = 16;
    private static final int pow16 = 65536;
    private static final int pow32_shift = 32;
    private static final long pow32_mask = 0xFFFFFFFF;

    public Number put(DataIn in) {
        long val = in.readUByte();
        if (val < u8) {
            return val;
        }
        var v = in.readUByte();
        val = ((val - u8) << pow8_shift) + u8 + v;
        if (val < u16) {
            return val;
        }
        var f = Short.toUnsignedInt(in.readShort());
        val = ((val - u16) << pow16_shift) + u16 + f;
        if (val < u32) {
            return val;
        }
        var f1 = Integer.toUnsignedLong(in.readInt());
        val = ((val - u32) << pow32_shift) + u32 + f1;
        if (val < u64) {
            return val;
        }
        throw new IllegalStateException();
    }

}
