package io.aether.net.fastMeta;

import io.aether.utils.dataio.DataInOut;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.futures.AFuture;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class FastApiContext implements FastFutureContext {
    final Map<Integer, FutureRec> futures = new ConcurrentHashMap<>();
    final AtomicInteger futuresCounter = new AtomicInteger();
    final Queue<byte[]> toRemote = new ConcurrentLinkedQueue<>();
    final AtomicInteger returnTasks = new AtomicInteger();

    @Override
    public FutureRec getFuture(int requestId) {
        return futures.remove(requestId);
    }

    @Override
    public void sendResultToRemote(int requestId) {
        FastFutureContext.super.sendResultToRemote(requestId);
        if (returnTasks.decrementAndGet() == 0) {
            flush(AFuture.make());
        }
    }

    @Override
    public void regLocalFuture() {
        returnTasks.incrementAndGet();
    }

    @Override
    public void sendResultToRemote(int requestId, byte[] data) {
        FastFutureContext.super.sendResultToRemote(requestId, data);
        if (returnTasks.decrementAndGet() == 0) {
            flush(AFuture.make());
        }
    }

    @Override
    public void sendToRemote(byte[] data) {
        toRemote.add(data);
        size.addAndGet(data.length);
    }

    @Override
    public boolean isEmpty() {
        return toRemote.isEmpty();
    }

    final AtomicInteger size = new AtomicInteger();
    @Override
    public int size() {
        return size.get();
    }

    public byte[] remoteDataToArray() {
        DataInOut out = new DataInOut();
        remoteDataToArray(out);
        return out.toArray();
    }

    public void remoteDataToArray(DataOut out) {
        while (true) {
            var d = toRemote.poll();
            if (d == null) break;
            out.write(d);
        }
    }

    @Override
    public int regFuture(FutureRec worker) {
        var r = futuresCounter.incrementAndGet();
        futures.put(r, worker);
        return r;
    }

    public <RT, RT2 extends RemoteApi> RT2 makeRemote(FastMetaApi<RT, RT2> meta) {
        return meta.makeRemote(this);
    }
}
