package io.aether.net.fastMeta;

import io.aether.utils.dataio.DataInOut;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.AFutureBase;
import io.aether.utils.interfaces.AFunction;
import io.aether.logger.Log;

import java.util.Arrays;

public interface FastFutureContext {
    FastFutureContext STUB = new FastFutureContext() {
        @Override
        public void sendToRemote(byte[] data) {

        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int regFuture(FutureRec worker) {
            return 0;
        }

        @Override
        public void flush(AFuture sendFuture) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FutureRec getFuture(int requestId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remoteDataToArray(DataOut out) {

        }
    };

    default void sendResultToRemote(int requestId) {
        var d = new DataInOut();
        FastMeta.META_COMMAND.serialize(STUB, 0, d);
        FastMeta.META_REQUEST_ID.serialize(STUB, requestId, d);
        sendToRemote(d.toArray());
    }

    default void sendResultToRemote(int requestId, byte[] data) {
        var d = new DataInOut();
        FastMeta.META_COMMAND.serialize(STUB, 0, d);
        FastMeta.META_REQUEST_ID.serialize(STUB, requestId, d);
        d.write(data);
        sendToRemote(d.toArray());
    }

    void sendToRemote(byte[] data);

    int regFuture(FutureRec worker);

    default void regLocalFuture() {

    }

    FutureRec getFuture(int requestId);

    default void flush(AFuture sendFuture){

    }
    default AFuture flush(){
        AFuture f=AFuture.make();
        flush(f);
        return f;
    }
    // ==================== LOGGED DEFAULT METHODS ====================

    default void invokeLocalMethodBefore(String methodName, String[] argsNames, Object[] argsValues){
        if (Log.TRACE) {
            int len = argsNames.length;
            // 2 slots for methodName, 2*len for args
            Object[] logData = new Object[2 + 2 * len];

            logData[0] = "methodName";
            logData[1] = methodName;

            for (int i = 0; i < len; i++) {
                logData[2 + 2 * i] = "arg_" + argsNames[i];
                logData[3 + 2 * i] = argsValues[i];
            }

            Log.trace("cmd local before: $methodName", logData);
        }
    }

    default void invokeLocalMethodAfter(String methodName, AFutureBase result, String[] argsNames, Object[] argsValues){
        if (Log.TRACE) {
            int len = argsNames.length;
            // 2 slots for methodName, 2 slots for result, 2*len for args
            Object[] logData = new Object[4 + 2 * len];

            logData[0] = "methodName";
            logData[1] = methodName;
            logData[2] = "result";
            logData[3] = result;

            for (int i = 0; i < len; i++) {
                logData[4 + 2 * i] = "arg_" + argsNames[i];
                logData[5 + 2 * i] = argsValues[i];
            }

            Log.trace("cmd local after : $methodName", logData);
        }
    }

    default void invokeRemoteMethodAfter(String methodName, AFutureBase result, String[] argsNames, Object[] argsValues){
        if (Log.TRACE) {
            int len = argsNames.length;
            // 2 slots for methodName, 2 slots for result, 2*len for args
            Object[] logData = new Object[4 + 2 * len];

            logData[0] = "methodName";
            logData[1] = methodName;
            logData[2] = "result";
            logData[3] = result;

            for (int i = 0; i < len; i++) {
                logData[4 + 2 * i] = "arg_" + argsNames[i];
                logData[5 + 2 * i] = argsValues[i];
            }

            Log.trace("cmd remote      : $methodName", logData);
        }
    }

    // ==================== END LOGGED DEFAULT METHODS ====================


    default byte[] remoteDataToArray() {
        DataInOut out = new DataInOut();
        remoteDataToArray(out);
        return out.toArray();
    }

    void remoteDataToArray(DataOut out);

    default AFuture close() {
        return AFuture.completed();
    }

    boolean isEmpty();

    int size();
}