package io.aether.net.fastMeta;

import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataInOutStatic;

public interface FastMetaApi<T, R extends RemoteApi> {
    /**
     * Создает имплементацию интерфейса R. Вызовы методов в этой имплементации приводят записи данных в
     * контекст ctx.
     *
     * @return Remote API implementation
     */
    R makeRemote(FastFutureContext ctx);

    /**
     * Принмиает бинарные данные из DataIn и десериализует их в вызовы методов для localApi
     * @param ctx
     * @param in
     * @param localApi
     */
    void makeLocal(FastFutureContext ctx, DataIn in, T localApi);

    /**
     * Сокращенный набор аргументов для удобства. Объект localApi извлекается из
     * контекста ctx.
     * @param ctx
     * @param in
     */
    default void makeLocal(FastApiContextLocal<? extends T> ctx, byte[] in) {
        makeLocal(ctx, in, ctx.localApi);
    }

    default void makeLocal(FastFutureContext ctx, byte[] in, T localApi) {
        makeLocal(ctx, new DataInOutStatic(in), localApi);
    }

}
