package io.aether.net.fastMeta;

import io.aether.utils.futures.AFuture;
import io.aether.utils.interfaces.Destroyable;

import java.net.URI;

/**
 * Interface for creating and managing a FastMeta client connection.
 * @param <LT> The type of the local API (what the client implements and receives).
 * @param <RT> The type of the remote API (what the client calls and sends).
 */
public interface FastMetaClient<LT, RT extends RemoteApi> extends FastMetaNet.Connection<LT,RT> {
    /**
     * Flushes any queued data on the underlying context.
     * This is a convenience method that finds the active context and calls flush on it.
     *
     * @param sendFuture A future to complete (done/cancel) based on the flush attempt.
     */
    void flush(AFuture sendFuture);
}