package io.aether.net.fastMeta;

import com.sun.jdi.ArrayReference;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.interfaces.Destroyable;

import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;

public interface FastMetaNet {
    AtomicReference<FastMetaNet> INSTANCE= new AtomicReference<>();
    <LT, RT extends RemoteApi> FastMetaClient<LT, RT> makeClient(
            URI uri,
            FastMetaApi<LT,?> lt,
            FastMetaApi<?,RT> rt,
            AFunction<RT, LT> localApi,
            WritableConsumer writableConsumer
            );
    interface WritableConsumer {
        void apply(boolean writable);
    }
    /**
     * Запускает сервер.
     *
     * @param uri           URI, определяющий протокол и адрес.
     * @param localApiMeta  FastMetaApi для десериализации вызовов LT (например, GlobalRegServerApi.META).
     * @param remoteApiMeta FastMetaApi для сериализации вызовов RT (например, GlobalRegClientApi.META).
     * @param handler       Обработчик новых соединений и их событий.
     * @return AFuture, который завершится, когда сервер успешно запустится.
     */
    <LT, RT extends RemoteApi> FastMetaServer<LT,RT> makeServer(
            URI uri,
            FastMetaApi<LT, ?> localApiMeta,
            FastMetaApi<?, RT> remoteApiMeta,
            FastMetaServer.Handler<LT, RT> handler);

    /**
     * Абстракция сетевого соединения для управления операциями ввода/вывода.
     *
     * @param <LT> Тип локального API (что реализует сервер).
     * @param <RT> Тип удаленного API (что вызывает сервер).
     */
    interface Connection<LT, RT extends RemoteApi> extends Destroyable {

        /**
         * Возобновляет чтение данных из сокета, если оно было приостановлено (autoread).
         */
        void read();

        /**
         * Приостанавливает чтение данных из сокета (используется для backpressure).
         * Рекомендуется вызывать после обработки каждого входящего пакета.
         */
        void stopRead();

        /**
         * Отправляет данные по сокету.
         *
         * @param data Данные для отправки.
         */
        AFuture write(byte[] data);

        /**
         * Получает локальный API (тот, что реализует сервер).
         */
        LT getLocalApi();

        /**
         * Получает удаленный прокси API (тот, что вызывает сервер на клиенте).
         */
        RT getRemoteApi();

        /**
         * Можно ли отправлять данные
         */
        boolean isWritable();
        /**
         * Возвращает контекст FastFutureContext, связанный с этим соединением.
         * Это необходимо, чтобы FastMeta мог использовать механизмы flush.
         *
         * @return FastFutureContext
         */
        FastFutureContext getMetaContext();
    }
}
