package io.aether.net.fastMeta;

import io.aether.utils.futures.AFuture;
import io.aether.utils.interfaces.Destroyable;

/**
 * Общий интерфейс для серверного транспорта FastMeta.
 *
 * @param <LT> Тип локального API (что сервер реализует и принимает).
 * @param <RT> Тип удаленного API (что сервер вызывает и отправляет).
 */
public interface FastMetaServer<LT, RT extends RemoteApi> extends Destroyable {


    AFuture stop();

    /**
     * Возвращает коллекцию (Iterable) всех активных соединений.
     * Полезно для перебора соединений с использованием цикла for-each.
     *
     * @return Iterable по ServerConnection LT, RT.
     */
    Iterable<FastMetaNet.Connection<LT, RT>> handlers(); // Изменено с Iterator на Iterable

    interface Handler<LT, RT extends RemoteApi> {

        // Обновлена сигнатура для использования параметризованного ServerConnection
        LT onNewConnection(FastMetaNet.Connection<LT, RT> connection);

        void onConnectionClose(FastMetaNet.Connection<LT, RT> connection);
    }

}