package io.aether.net.fastMeta;

import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataInOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataOut;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public interface FastMetaType<T> {
    default byte[] serialize(T obj) {
        DataInOut d = new DataInOut();
        serialize(FastFutureContext.STUB, obj, d);
        return d.toArray();
    }
    default T loadFromFile(String file){
        try {
            var d=Files.readAllBytes(Path.of(file));
            return deserialize(d);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
    void serialize(FastFutureContext ctx, T obj, DataOut out);

    default T deserialize(byte[] data) {
        var d = new DataInOutStatic(data);
        return deserialize(FastFutureContext.STUB, d);
    }

    T deserialize(FastFutureContext ctx, DataIn in);
}
