package io.aether.net.fastMeta;

import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.utils.ConcurrentHashSet;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import io.aether.utils.interfaces.ABiConsumer;
import io.aether.utils.interfaces.ABiFunction;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.interfaces.AFunction;

import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class RemoteApiFuture<T extends RemoteApi> {
    final Queue<ABiConsumer<T, AFuture>> queue = new ConcurrentLinkedQueue<>();
    final Set<ABiConsumer<T, AFuture>> permanent = new ConcurrentHashSet<>();
    final FastMetaApi<?, T> meta;
    final LNode logContext = Log.of();

    public RemoteApiFuture(FastMetaApi<?, T> meta) {
        this.meta = meta;
    }

    public void run(AConsumer<T> t) {
        run(Log.wrap((a, f) -> t.accept(a)));
    }

    public void run(ABiConsumer<T, AFuture> t) {
        queue.add(Log.wrap(t));
    }

    public <R> ARFuture<R> runRes(AFunction<T, ARFuture<R>> t) {
        return runRes((a, f) -> t.apply(a));
    }

    public <R> ARFuture<R> runRes(ABiFunction<T, AFuture, ARFuture<R>> t) {
        ARFuture<R> res = ARFuture.make();
        run((a, f) -> {
            t.apply(a, f).to(res);
        });
        return res;
    }

    public void executeAll(FastFutureContext ctx, AFuture sendFuture) {
        try (var ln = logContext.context()) {
            T api = meta.makeRemote(ctx);
            while (true) {
                var e = queue.poll();
                if (e == null) break;
                e.accept(api, sendFuture);
            }
            for (var t : permanent) {
                t.accept(api, sendFuture);
            }
        }
    }

    public void addPermanent(AConsumer<T> task) {
        permanent.add((a, f) -> task.accept(a));
    }

    public void addPermanent(ABiConsumer<T, AFuture> task) {
        permanent.add(Log.wrap(task));
    }

    public boolean isEmpty() {
        return queue.isEmpty() && permanent.isEmpty();
    }

    public int size() {
        return queue.size() + permanent.size();
    }
}
