package io.aether.net.fastMeta;

import io.aether.utils.dataio.DataOut;

public class SerializerPackNumber {
    public static final SerializerPackNumber INSTANCE = new SerializerPackNumber();
    static final long u8 = 251;
    static final long pow8_mask = 0xff;
    static final long pow8_shift = 8;
    static final long pow8 = 256;
    static final long k8ReservedFor16 = 16;
    static final long k16ReservedFor32 = 256;
    static final long pow32 = 4L * 1024 * 1024 * 1024;
    static final long u16 = 5 * 256 + u8 - k8ReservedFor16;  // 1515
    static final long u32 = 1024 * 1024 + u16 - k16ReservedFor32;  // 1 049 835
    static final long u64 = u32 + pow32 * k16ReservedFor32;
    // maximum supported value is (1 Tb + 1 Mb + 1515 - 1)
    static final long pow16_mask = 0xFFFF;
    static final long pow16_shift = 16;
    static final long pow16 = 65536;
    static final long pow32_shift = 32;
    static final long pow32_mask = 0xFFFFFFFFL;

    public int calcSize(long v) {
        if (v < u8) return 1;
        if (v < u16) return 2;
        if (v < u32) return 4;
        if (v < u64) return 8;
        throw new IllegalStateException();
    }

    public void put(DataOut out, Number value) {
        var v = value.longValue();
        put(out, v);
    }

    public void put(DataOut out, int value) {
        put(out, (long) value);
    }

    public void put(DataOut out, long v) {
        if (v < u8) {
            out.writeByte((byte) v);
        } else if (v < u16) {
            out.writeByte((int) ((((v - u8) >> pow8_shift) & 0xffL) + u8));
            out.writeByte((int) ((v - u8) & pow8_mask));
        } else if (v < u32) {
            out.writeByte(255);
            out.writeByte((int) (((v - u16) >> pow16_shift) - u8 + u16));
            out.writeShort((short) ((v - u16) & pow16_mask));
        } else if (v < u64) {
            out.writeByte(255);
            out.writeByte(255);
            out.writeShort((short) (((v - u32) >> pow32_shift) - u16 + u32));
            out.writeInt((int) ((v - u32) & pow32_mask));
        }
    }
}
