/*
 * Decompiled with CFR 0.152.
 */
package io.aether.net.fastMeta;

import io.aether.net.fastMeta.FastFutureContext;
import io.aether.net.fastMeta.FastMetaApi;
import io.aether.net.fastMeta.FutureRec;
import io.aether.net.fastMeta.RemoteApi;
import io.aether.utils.dataio.DataInOut;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.futures.AFuture;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class FastApiContext
implements FastFutureContext {
    final Map<Integer, FutureRec> futures = new ConcurrentHashMap<Integer, FutureRec>();
    final AtomicInteger futuresCounter = new AtomicInteger();
    final Queue<byte[]> toRemote = new ConcurrentLinkedQueue<byte[]>();
    final AtomicInteger returnTasks = new AtomicInteger();
    final AtomicInteger size = new AtomicInteger();

    @Override
    public FutureRec getFuture(int requestId) {
        return this.futures.remove(requestId);
    }

    @Override
    public void sendResultToRemote(int requestId) {
        FastFutureContext.super.sendResultToRemote(requestId);
        if (this.returnTasks.decrementAndGet() == 0) {
            this.flush(AFuture.make());
        }
    }

    @Override
    public void regLocalFuture() {
        this.returnTasks.incrementAndGet();
    }

    @Override
    public void sendResultToRemote(int requestId, byte[] data) {
        FastFutureContext.super.sendResultToRemote(requestId, data);
        if (this.returnTasks.decrementAndGet() == 0) {
            this.flush(AFuture.make());
        }
    }

    @Override
    public void sendToRemote(byte[] data) {
        this.toRemote.add(data);
        this.size.addAndGet(data.length);
    }

    @Override
    public boolean isEmpty() {
        return this.toRemote.isEmpty();
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public byte[] remoteDataToArray() {
        DataInOut out = new DataInOut();
        this.remoteDataToArray((DataOut)out);
        return out.toArray();
    }

    @Override
    public void remoteDataToArray(DataOut out) {
        byte[] d;
        while ((d = this.toRemote.poll()) != null) {
            out.write(d);
        }
    }

    @Override
    public int regFuture(FutureRec worker) {
        int r = this.futuresCounter.incrementAndGet();
        this.futures.put(r, worker);
        return r;
    }

    public <RT, RT2 extends RemoteApi> RT2 makeRemote(FastMetaApi<RT, RT2> meta) {
        return meta.makeRemote(this);
    }
}

