/*
 * Decompiled with CFR 0.152.
 */
package io.aether.net.fastMeta;

import io.aether.utils.dataio.DataOut;

public class SerializerPackNumber {
    public static final SerializerPackNumber INSTANCE = new SerializerPackNumber();
    static final long u8 = 251L;
    static final long pow8_mask = 255L;
    static final long pow8_shift = 8L;
    static final long pow8 = 256L;
    static final long k8ReservedFor16 = 16L;
    static final long k16ReservedFor32 = 256L;
    static final long pow32 = 0x100000000L;
    static final long u16 = 1515L;
    static final long u32 = 1049835L;
    static final long u64 = 1099512677611L;
    static final long pow16_mask = 65535L;
    static final long pow16_shift = 16L;
    static final long pow16 = 65536L;
    static final long pow32_shift = 32L;
    static final long pow32_mask = 0xFFFFFFFFL;

    public int calcSize(long v) {
        if (v < 251L) {
            return 1;
        }
        if (v < 1515L) {
            return 2;
        }
        if (v < 1049835L) {
            return 4;
        }
        if (v < 1099512677611L) {
            return 8;
        }
        throw new IllegalStateException();
    }

    public void put(DataOut out, Number value) {
        long v = value.longValue();
        this.put(out, v);
    }

    public void put(DataOut out, int value) {
        this.put(out, (long)value);
    }

    public void put(DataOut out, long v) {
        if (v < 251L) {
            out.writeByte((int)((byte)v));
        } else if (v < 1515L) {
            out.writeByte((int)((v - 251L >> 8 & 0xFFL) + 251L));
            out.writeByte((int)(v - 251L & 0xFFL));
        } else if (v < 1049835L) {
            out.writeByte(255);
            out.writeByte((int)((v - 1515L >> 16) - 251L + 1515L));
            out.writeShort((short)(v - 1515L & 0xFFFFL));
        } else if (v < 1099512677611L) {
            out.writeByte(255);
            out.writeByte(255);
            out.writeShort((short)((v - 1049835L >> 32) - 1515L + 1049835L));
            out.writeInt((int)(v - 1049835L & 0xFFFFFFFFL));
        }
    }
}

