/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.dbSupport;

import io.aether.utils.dbSupport.IDBWorker;
import io.aether.utils.dbSupport.IDatabaseManager;
import io.aether.utils.dbSupport.IEntityMetadata;
import io.aether.utils.dbSupport.PostgreSQLWorker;
import io.aether.utils.dbSupport.TableInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public final class DatabaseManager
implements IDatabaseManager {
    private final IDBWorker worker;
    private final List<IEntityMetadata<?>> entityMetadata = new ArrayList();
    private final Executor executor;

    public DatabaseManager(String customUrl) throws URISyntaxException, SQLException {
        this(new URI(customUrl));
    }

    public DatabaseManager(String customUrl, Executor executor) throws URISyntaxException, SQLException {
        this(new URI(customUrl), executor);
    }

    public DatabaseManager(URI uri) {
        this(uri, (Executor)Executors.newCachedThreadPool(r -> {
            Thread t = new Thread(r, "DatabaseManager");
            t.setDaemon(true);
            return t;
        }));
    }

    public DatabaseManager(URI uri, Executor executor) {
        this.executor = executor;
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        String userInfo = uri.getUserInfo();
        String dbName = uri.getPath().substring(1);
        String user = null;
        String password = null;
        if (userInfo != null) {
            String[] parts = userInfo.split(":");
            user = parts[0];
            if (parts.length > 1) {
                password = parts[1];
            }
        }
        switch (scheme) {
            case "postgresql": {
                String jdbcUrl = "jdbc:postgresql://" + host + ":" + port + "/" + dbName;
                try {
                    this.worker = new PostgreSQLWorker(jdbcUrl, user, password);
                    break;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            case "clickhouse": {
                throw new IllegalArgumentException("ClickHouse support is not implemented yet");
            }
            default: {
                throw new IllegalArgumentException("Unsupported database scheme: " + scheme);
            }
        }
    }

    @Override
    public void registerEntity(IEntityMetadata<?> metadata) {
        this.entityMetadata.add(metadata);
    }

    @Override
    public void initialize() throws SQLException {
        for (IEntityMetadata<?> metadata : this.entityMetadata) {
            TableInfo tableInfo = this.worker.getTableInfo(metadata.getTableName());
            if (tableInfo == null) {
                this.worker.initializeTable(metadata.getTableName(), metadata.getCreateTableSql());
                continue;
            }
            metadata.validateAndUpdateTable(tableInfo);
        }
    }

    @Override
    public Map<String, TableInfo> getTableInfo(String tableName) throws SQLException {
        return this.worker.getDatabaseMetadata();
    }

    @Override
    public void close() {
        if (this.worker != null) {
            try {
                this.worker.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public IDBWorker getWorker() {
        return this.worker;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }
}

