/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.dbSupport;

import io.aether.utils.dbSupport.IDatabaseManager;
import io.aether.utils.dbSupport.TableInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.function.Consumer;

public interface IEntityMetadata<T> {
    public Class<T> getEntityClass();

    public String getTableName();

    public String getCreateTableSql();

    public IDatabaseManager getDatabaseManager();

    public T mapRow(ResultSet var1) throws SQLException;

    public void validateAndUpdateTable(TableInfo var1) throws SQLException;

    public void findById(Object var1, Consumer<T> var2, Consumer<Exception> var3);

    public void save(T var1, Consumer<T> var2, Consumer<Exception> var3);

    default public void save(T entity) {
        this.save(entity, v -> {}, e -> {});
    }

    public void deleteById(Object var1, Consumer<Boolean> var2, Consumer<Exception> var3);

    public void deleteAll(Consumer<Boolean> var1, Consumer<Exception> var2);

    default public void deleteAll() {
        this.deleteAll(v -> {}, e -> {});
    }

    public void findAll(Consumer<List<T>> var1, Consumer<Exception> var2);

    default public void findAllEach(Consumer<T> resultHandler, Consumer<Exception> errorHandler) {
        this.findAll(vv -> {
            for (Object v : vv) {
                resultHandler.accept(v);
            }
        }, errorHandler);
    }
}

