/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.dbSupport;

import io.aether.utils.dbSupport.ColumnInfo;
import io.aether.utils.dbSupport.IDBWorker;
import io.aether.utils.dbSupport.IEntityMetadata;
import io.aether.utils.dbSupport.TableInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class PostgreSQLWorker
implements IDBWorker {
    private final Connection connection;

    public PostgreSQLWorker(String jdbcUrl, String user, String password) throws SQLException {
        this.connection = DriverManager.getConnection(jdbcUrl, user, password);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> List<T> executeSelect(String sql, Object[] params, IEntityMetadata<T> metadata) throws SQLException {
        try (PreparedStatement stmt = this.prepareStatement(sql, params);){
            ArrayList<T> arrayList;
            block17: {
                ResultSet rs = stmt.executeQuery();
                try {
                    ArrayList<T> results = new ArrayList<T>();
                    while (rs.next()) {
                        try {
                            results.add(metadata.mapRow(rs));
                        }
                        catch (Exception exception) {}
                    }
                    arrayList = results;
                    if (rs == null) break block17;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            String fullSql = this.formatSql(sql, params);
            throw new SQLException("SQL Error executing select:\n" + fullSql, e);
        }
    }

    @Override
    public int executeUpdate(String sql, Object ... params) throws SQLException {
        int n;
        block8: {
            PreparedStatement stmt = this.prepareStatement(sql, params);
            try {
                n = stmt.executeUpdate();
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    String fullSql = this.formatSql(sql, params);
                    throw new SQLException("SQL Error executing update:\n" + fullSql, e);
                }
            }
            stmt.close();
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object executeInsert(String sql, Object[] params) throws SQLException {
        try (PreparedStatement stmt = this.connection.prepareStatement(sql, 1);){
            this.setParameters(stmt, params);
            stmt.executeUpdate();
            try (ResultSet generatedKeys = stmt.getGeneratedKeys();){
                if (generatedKeys.next()) {
                    Object object = generatedKeys.getObject(1);
                    return object;
                }
            }
            generatedKeys = null;
            return generatedKeys;
        }
        catch (SQLException e) {
            String fullSql = this.formatSql(sql, params);
            throw new SQLException("SQL Error executing insert:\n" + fullSql, e);
        }
    }

    @Override
    public TableInfo getTableInfo(String tableName) throws SQLException {
        DatabaseMetaData metaData = this.connection.getMetaData();
        try (ResultSet tables = metaData.getTables(null, null, tableName, new String[]{"TABLE"});){
            if (!tables.next()) {
                TableInfo tableInfo = null;
                return tableInfo;
            }
        }
        HashMap<String, ColumnInfo> columns = new HashMap<String, ColumnInfo>();
        try (ResultSet columnsRs = metaData.getColumns(null, null, tableName, null);){
            while (columnsRs.next()) {
                String columnName = columnsRs.getString("COLUMN_NAME");
                String columnType = columnsRs.getString("TYPE_NAME");
                int columnSize = columnsRs.getInt("COLUMN_SIZE");
                boolean isNullable = "YES".equals(columnsRs.getString("IS_NULLABLE"));
                String defaultValue = columnsRs.getString("COLUMN_DEF");
                boolean isPrimaryKey = false;
                try (ResultSet primaryKeys = metaData.getPrimaryKeys(null, null, tableName);){
                    while (primaryKeys.next()) {
                        if (!columnName.equals(primaryKeys.getString("COLUMN_NAME"))) continue;
                        isPrimaryKey = true;
                        break;
                    }
                }
                Object fullType = columnType;
                if (columnSize > 0 && !columnType.equals("TEXT") && !columnType.equals("BLOB")) {
                    fullType = (String)fullType + "(" + columnSize + ")";
                }
                columns.put(columnName.toLowerCase(), new ColumnInfo(columnName, (String)fullType, isNullable, isPrimaryKey, defaultValue));
            }
        }
        return new TableInfo(tableName, columns);
    }

    @Override
    public Map<String, TableInfo> getDatabaseMetadata() throws SQLException {
        HashMap<String, TableInfo> tableInfoMap = new HashMap<String, TableInfo>();
        DatabaseMetaData metaData = this.connection.getMetaData();
        try (ResultSet tables = metaData.getTables(null, null, null, new String[]{"TABLE"});){
            while (tables.next()) {
                String tableName = tables.getString("TABLE_NAME");
                tableInfoMap.put(tableName, this.getTableInfo(tableName));
            }
        }
        return tableInfoMap;
    }

    @Override
    public void addColumn(String tableName, String columnName, String sqlType, String constraints) throws SQLException {
        String sql = String.format("ALTER TABLE %s ADD COLUMN %s %s %s", tableName, columnName, sqlType, constraints);
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(sql);
        }
        catch (SQLException e) {
            throw new SQLException("Error adding column '" + columnName + "' to table '" + tableName + "':\n" + sql, e);
        }
    }

    @Override
    public void initializeTable(String tableName, String createTableSql) throws SQLException {
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(createTableSql);
        }
        catch (SQLException e) {
            throw new SQLException("Error creating table '" + tableName + "':\n" + createTableSql, e);
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
    }

    @Override
    public boolean isTypeCompatible(String expectedSqlType, String actualDbType) {
        String actual;
        String expected = expectedSqlType.toUpperCase();
        if (expected.equals(actual = actualDbType.toUpperCase())) {
            return true;
        }
        switch (expected) {
            case "TEXT": {
                return actual.contains("TEXT") || actual.contains("VARCHAR") || actual.contains("CHARACTER VARYING") || actual.contains("BYTEA");
            }
            case "BLOB": {
                return actual.contains("BYTEA");
            }
            case "UUID": {
                return actual.contains("UUID");
            }
            case "BOOLEAN": {
                return actual.contains("BOOLEAN") || actual.contains("BOOL");
            }
            case "INTEGER": {
                return actual.contains("INT") || actual.contains("SERIAL");
            }
            case "BIGINT": {
                return actual.contains("BIGINT") || actual.contains("BIGSERIAL") || actual.contains("INT8");
            }
            case "DOUBLE PRECISION": {
                return actual.contains("FLOAT8") || actual.contains("DOUBLE PRECISION");
            }
        }
        return expected.equals(actual);
    }

    private PreparedStatement prepareStatement(String sql, Object[] params) throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement(sql);
        this.setParameters(stmt, params);
        return stmt;
    }

    private void setParameters(PreparedStatement stmt, Object[] params) throws SQLException {
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                stmt.setObject(i + 1, params[i]);
            }
        }
    }

    private String formatSql(String sql, Object[] params) {
        if (params == null || params.length == 0) {
            return sql;
        }
        String formattedSql = sql;
        for (Object param : params) {
            Object paramStr;
            Object object = paramStr = param != null ? param.toString() : "null";
            if (param instanceof String || param instanceof UUID) {
                paramStr = "'" + (String)paramStr + "'";
            }
            formattedSql = formattedSql.replaceFirst("\\?", (String)paramStr);
        }
        return formattedSql;
    }
}

