/*
 * Decompiled with CFR 0.152.
 */
package io.aether.net.fastMeta;

import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.net.fastMeta.FastFutureContext;
import io.aether.net.fastMeta.FastMetaApi;
import io.aether.net.fastMeta.RemoteApi;
import io.aether.utils.ConcurrentHashSet;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import io.aether.utils.interfaces.ABiConsumer;
import io.aether.utils.interfaces.ABiFunction;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.interfaces.AFunction;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class RemoteApiFuture<T extends RemoteApi> {
    final Queue<ABiConsumer<T, AFuture>> queue = new ConcurrentLinkedQueue<ABiConsumer<T, AFuture>>();
    final Set<ABiConsumer<T, AFuture>> permanent = new ConcurrentHashSet();
    final AtomicBoolean flushProcess = new AtomicBoolean();
    final FastMetaApi<?, T> meta;
    final LNode logContext;

    public RemoteApiFuture(FastMetaApi<?, T> meta) {
        this.meta = meta;
        this.logContext = Log.createContext();
    }

    public void run(AConsumer<T> t) {
        this.run(Log.wrap((a, f) -> t.accept(a)));
    }

    public void run(ABiConsumer<T, AFuture> t) {
        this.queue.add(Log.wrap(t));
    }

    public <R> ARFuture<R> runRes(AFunction<T, ARFuture<R>> t) {
        return this.runRes((a, f) -> (ARFuture)t.apply(a));
    }

    public <R> ARFuture<R> runRes(ABiFunction<T, AFuture, ARFuture<R>> t) {
        ARFuture res = ARFuture.make();
        this.run((a, f) -> ((ARFuture)t.apply(a, f)).to(res));
        return res;
    }

    public void executeAll(FastFutureContext ctx, AFuture sendFuture) {
        try (Log.LogAutoClose ln = Log.context((LNode)this.logContext);){
            ABiConsumer<T, AFuture> e;
            T api = this.meta.makeRemote(ctx);
            while ((e = this.queue.poll()) != null) {
                e.accept(api, (Object)sendFuture);
            }
            for (ABiConsumer<T, AFuture> t : this.permanent) {
                t.accept(api, (Object)sendFuture);
            }
        }
    }

    public void addPermanent(AConsumer<T> task) {
        this.permanent.add((a, f) -> task.accept(a));
    }

    public void addPermanent(ABiConsumer<T, AFuture> task) {
        this.permanent.add(task);
    }

    public boolean isEmpty() {
        return this.queue.isEmpty() && this.permanent.isEmpty();
    }

    public int size() {
        return this.queue.size() + this.permanent.size();
    }
}

