package io.aether.net.fastMeta.netty;

import io.aether.net.fastMeta.DeserializerPackNumber;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;

class FastMetaFrameDecoder extends ByteToMessageDecoder {

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        in.markReaderIndex();

        // 1. Оборачиваем ByteBuf в нашу реализацию DataIn
        ByteBufDataIO dataIn = new ByteBufDataIO(in);
        int payloadSize;

        try {
            // 2. DeserializerPackNumber работает с DataIn
            payloadSize = DeserializerPackNumber.INSTANCE.put(dataIn).intValue();
        } catch (Exception e) {
            // Недостаточно данных для чтения размера, ждем
            in.resetReaderIndex();
            return;
        }

        // 3. Проверяем, есть ли полный payload
        if (in.readableBytes() < payloadSize) {
            in.resetReaderIndex();
            return; // Ждем
        }

        // 4. Передаем payload (как ByteBuf) дальше
        out.add(in.readBytes(payloadSize));
    }
}