package io.aether.net.fastMeta.netty;

import io.aether.net.fastMeta.SerializerPackNumber;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;

class FastMetaFrameEncoder extends MessageToByteEncoder<byte[]> {

    @Override
    protected void encode(ChannelHandlerContext ctx, byte[] msg, ByteBuf out) {

        // 1. Оборачиваем выходной ByteBuf в нашу реализацию DataOut
        ByteBufDataIO dataOut = new ByteBufDataIO(out);

        // 2. SerializerPackNumber работает с DataOut
        SerializerPackNumber.INSTANCE.put(dataOut, msg.length);

        // 3. Пишем сам payload
        out.writeBytes(msg);
    }
}