/*
 * Decompiled with CFR 0.152.
 */
package io.aether.net.fastMeta.netty;

import io.aether.utils.dataio.DataIO;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataInOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.netty.buffer.ByteBuf;

public class ByteBufDataIO
implements DataIO {
    private final ByteBuf buf;

    public ByteBufDataIO(ByteBuf buf) {
        this.buf = buf;
    }

    public int getSizeForRead() {
        return this.buf.readableBytes();
    }

    public int read(byte[] b, int offset, int len) {
        int readable = this.buf.readableBytes();
        if (readable == 0) {
            return len == 0 ? 0 : -1;
        }
        int readLen = Math.min(len, readable);
        this.buf.readBytes(b, offset, readLen);
        return readLen;
    }

    public int read(int[] b, int offset, int len) {
        int endIndex = Math.min(offset + len, b.length);
        for (int i = offset; i < endIndex; ++i) {
            if (this.buf.readableBytes() < 4) {
                return i - offset;
            }
            b[i] = this.readInt();
        }
        return endIndex - offset;
    }

    public void skipBytes(int n) {
        this.buf.skipBytes(n);
    }

    public boolean readBoolean() {
        return this.buf.readByte() != 0;
    }

    public byte readByte() {
        return this.buf.readByte();
    }

    public int readUByte() {
        return this.buf.readUnsignedByte() & 0xFF;
    }

    public DataIO readSubData(int length) {
        return new ByteBufDataIO(this.buf.readSlice(length));
    }

    public short readShort() {
        return this.buf.readShortLE();
    }

    public int readUShort() {
        return this.buf.readUnsignedShortLE() & 0xFFFF;
    }

    public char readChar() {
        return (char)this.readUByte();
    }

    public int readInt() {
        return this.buf.readIntLE();
    }

    public long readUInt() {
        return this.buf.readUnsignedIntLE() & 0xFFFFFFFFL;
    }

    public long readLong() {
        return this.buf.readLongLE();
    }

    public float readFloat() {
        return this.buf.readFloatLE();
    }

    public double readDouble() {
        return this.buf.readDoubleLE();
    }

    public String readString1() {
        int len = this.readUByte();
        byte[] data = new byte[len];
        this.read(data);
        return new String(data);
    }

    public int indexOf(int limit, byte val) {
        int searchLength = Math.min(limit, this.buf.readableBytes());
        return this.buf.indexOf(this.buf.readerIndex(), this.buf.readerIndex() + searchLength, val);
    }

    public int write(byte[] b, int off, int len) {
        int writeLen = Math.min(len, this.buf.writableBytes());
        this.buf.writeBytes(b, off, writeLen);
        return writeLen;
    }

    public int write(int[] b, int off, int len) {
        int endIndex = Math.min(off + len, b.length);
        for (int i = off; i < endIndex; ++i) {
            if (this.buf.writableBytes() < 4) {
                return i - off;
            }
            this.writeInt(b[i]);
        }
        return endIndex - off;
    }

    public void writeBoolean(boolean v) {
        this.buf.writeByte(v ? 1 : 0);
    }

    public void writeByte(int v) {
        this.buf.writeByte(v);
    }

    public void writeShort(short v) {
        this.buf.writeShortLE((int)v);
    }

    public void writeShort(int v) {
        this.buf.writeShortLE(v);
    }

    public void writeChar(char v) {
        this.writeByte((byte)v);
    }

    public void writeInt(int v) {
        this.buf.writeIntLE(v);
    }

    public void writeLong(long v) {
        this.buf.writeLongLE(v);
    }

    public void writeFloat(float v) {
        this.buf.writeFloatLE(v);
    }

    public void writeDouble(double v) {
        this.buf.writeDoubleLE(v);
    }

    public boolean isWritable() {
        return this.buf.isWritable();
    }

    public int getSizeForWrite() {
        return this.buf.writableBytes();
    }

    public void write(DataInOut data) {
        this.write(data.data, data.readPos, data.getSizeForRead());
        data.readPos = data.writePos;
    }

    public void write(DataInOutStatic data) {
        this.write(data.data, data.readPos, data.getSizeForRead());
        data.readPos = data.writePos;
    }

    public void write(DataIn data) {
        if (data instanceof ByteBufDataIO) {
            this.buf.writeBytes(((ByteBufDataIO)data).buf);
        } else {
            super.write(data);
        }
    }
}

