/*
 * Decompiled with CFR 0.152.
 */
package io.aether.net.fastMeta.netty;

import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.net.fastMeta.FastApiContext;
import io.aether.net.fastMeta.FastFutureContext;
import io.aether.net.fastMeta.FastMetaApi;
import io.aether.net.fastMeta.FastMetaClient;
import io.aether.net.fastMeta.FastMetaNet;
import io.aether.net.fastMeta.RemoteApi;
import io.aether.net.fastMeta.netty.ByteBufDataIO;
import io.aether.net.fastMeta.netty.FastMetaFrameDecoder;
import io.aether.net.fastMeta.netty.FastMetaFrameEncoder;
import io.aether.net.fastMeta.netty.NettyFastMetaNet;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataInOut;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.futures.AFuture;
import io.aether.utils.interfaces.AFunction;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.ReferenceCountUtil;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

@ChannelHandler.Sharable
class NettyFastMetaClient<LT, RT extends RemoteApi>
extends ChannelInboundHandlerAdapter
implements FastMetaClient<LT, RT> {
    private final boolean isWebSocket;
    private static final int RECONNECT_DELAY_SECONDS = 1;
    private final NettyFastMetaNet nettyNet;
    private final URI uri;
    private final boolean isUdp;
    private final FastMetaApi<LT, ?> localApiMeta;
    private final FastMetaNet.WritableConsumer writableConsumer;
    private final LNode logContext;
    private final Bootstrap bootstrap;
    private final FastApiContext context;
    private final RT remoteApi;
    private final LT localApi;
    private volatile ChannelHandlerContext ctx;
    private volatile boolean active = true;

    NettyFastMetaClient(NettyFastMetaNet nettyNet, final URI uri, FastMetaApi<LT, ?> lt, FastMetaApi<?, RT> rt, AFunction<RT, LT> localApiProvider, FastMetaNet.WritableConsumer writableConsumer) {
        this.nettyNet = nettyNet;
        this.uri = uri;
        this.isUdp = "udp".equals(uri.getScheme());
        this.localApiMeta = lt;
        this.writableConsumer = writableConsumer;
        this.logContext = Log.of((Object[])new Object[]{"uri", uri, "socket", "client netty"});
        this.isWebSocket = "ws".equals(uri.getScheme()) || "wss".equals(uri.getScheme());
        this.context = new FastApiContext(){

            public void flush(AFuture sendFuture) {
                NettyFastMetaClient.this.handleFlush(sendFuture);
            }
        };
        this.remoteApi = rt.makeRemote((FastFutureContext)this.context);
        this.localApi = localApiProvider.apply(this.remoteApi);
        this.bootstrap = new Bootstrap();
        ((Bootstrap)this.bootstrap.group(nettyNet.getWorkerGroup())).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        if (this.isUdp) {
            Class<DatagramChannel> datagramChannelClass = this.getDatagramChannelClass();
            ((Bootstrap)this.bootstrap.channel(datagramChannelClass)).handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(){

                protected void initChannel(DatagramChannel ch) {
                    ch.pipeline().addLast("handler", (ChannelHandler)NettyFastMetaClient.this);
                }
            });
        } else {
            ((Bootstrap)this.bootstrap.channel(nettyNet.getClientChannelClass())).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(this){
                final /* synthetic */ NettyFastMetaClient this$0;
                {
                    this.this$0 = this$0;
                }

                protected void initChannel(SocketChannel ch) {
                    if (this.this$0.isWebSocket) {
                        try (LNode.AutoCloseable _l = this.this$0.logContext.context();){
                            Log.info((String)"Initializing WebSocket client pipeline", (LNode[])new LNode[0]);
                            WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)new DefaultHttpHeaders());
                            NettyWebSocketClientHandshakerHandler handshakerHandler = new NettyWebSocketClientHandshakerHandler(handshaker, this.this$0.logContext, ctx -> this.this$0.channelActive((ChannelHandlerContext)ctx), () -> {
                                if (this.this$0.ctx != null) {
                                    this.this$0.channelInactive(this.this$0.ctx);
                                }
                            });
                            ch.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), handshakerHandler});
                            ch.pipeline().addLast("ws_to_buf_decoder", (ChannelHandler)new MessageToMessageDecoder<BinaryWebSocketFrame>(this){

                                protected void decode(ChannelHandlerContext ctx, BinaryWebSocketFrame msg, List<Object> out) {
                                    out.add(msg.content().retain());
                                }
                            });
                            ch.pipeline().addLast("frameDecoder", (ChannelHandler)new FastMetaFrameDecoder());
                            ch.pipeline().addLast("buf_to_ws_encoder", (ChannelHandler)new MessageToMessageEncoder<ByteBuf>(this){

                                protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) {
                                    out.add(new BinaryWebSocketFrame(msg.retain()));
                                }
                            });
                            ch.pipeline().addLast("frameEncoder", (ChannelHandler)new FastMetaFrameEncoder());
                            ch.pipeline().addLast("handler", (ChannelHandler)this.this$0);
                        }
                    } else {
                        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new FastMetaFrameDecoder());
                        ch.pipeline().addLast("frameEncoder", (ChannelHandler)new FastMetaFrameEncoder());
                        ch.pipeline().addLast("handler", (ChannelHandler)this.this$0);
                    }
                }
            });
        }
        this.tryConnect();
    }

    private Class<? extends DatagramChannel> getDatagramChannelClass() {
        Class<? extends Channel> clientChannelClass = this.nettyNet.getClientChannelClass();
        if (clientChannelClass == EpollSocketChannel.class) {
            return EpollDatagramChannel.class;
        }
        if (clientChannelClass == KQueueSocketChannel.class) {
            return KQueueDatagramChannel.class;
        }
        return NioDatagramChannel.class;
    }

    private void tryConnect() {
        if (!this.active) {
            return;
        }
        try (LNode.AutoCloseable _l = this.logContext.context();){
            Log.info((String)"Attempting to connect...", (LNode[])new LNode[0]);
            this.bootstrap.connect(this.uri.getHost(), this.uri.getPort()).addListener(future -> {
                try (LNode.AutoCloseable _l_listener = this.logContext.context();){
                    if (future.isSuccess()) {
                        Log.info((String)"Connection established", (Object[])new Object[]{"local", future.channel().localAddress()});
                    } else {
                        this.scheduleReconnect();
                    }
                }
            });
        }
    }

    private void scheduleReconnect() {
        if (!this.active) {
            return;
        }
        this.writableConsumer.apply(false);
        try (LNode.AutoCloseable _l = this.logContext.context();){
            Log.info((String)"Scheduling reconnect...", (Object[])new Object[]{"delaySeconds", 1});
        }
        this.nettyNet.getWorkerGroup().schedule(this::tryConnect, 1L, TimeUnit.SECONDS);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        try (LNode.AutoCloseable _l = this.logContext.context();){
            this.ctx = ctx;
            this.writableConsumer.apply(true);
            Log.info((String)"Netty client connected", (LNode[])new LNode[0]);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        try (LNode.AutoCloseable _l = this.logContext.context();){
            this.ctx = null;
            Log.warn((String)"Netty client connection lost", (LNode[])new LNode[0]);
            this.scheduleReconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        try (LNode.AutoCloseable _l = this.logContext.context();){
            ByteBuf payload = null;
            if (msg instanceof ByteBuf) {
                payload = (ByteBuf)msg;
            } else if (msg instanceof DatagramPacket) {
                payload = (ByteBuf)((DatagramPacket)msg).content();
            } else {
                Log.warn((String)"Received unexpected message type, ignoring.", (Object[])new Object[]{"type", msg.getClass().getName()});
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            ByteBufDataIO in = null;
            try {
                in = new ByteBufDataIO(payload);
                this.localApiMeta.makeLocal((FastFutureContext)this.context, (DataIn)in, this.localApi);
            }
            catch (Exception e) {
                Log.error((String)"Error during makeLocal (packet processing).", (Throwable)e, (Object[])new Object[0]);
                ctx.close();
            }
            finally {
                if (payload != null) {
                    payload.release();
                }
            }
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        this.writableConsumer.apply(ctx.channel().isWritable());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        try (LNode.AutoCloseable _l = this.logContext.context();){
            Log.warn((String)"Netty client exception caught", (Throwable)cause, (Object[])new Object[0]);
            ctx.close();
        }
    }

    public void flush(AFuture sendFuture) {
        this.context.flush(sendFuture);
    }

    private void handleFlush(AFuture sendFuture) {
        try (LNode.AutoCloseable _l = this.logContext.context();){
            Object dataToSend;
            ChannelHandlerContext currentCtx = this.ctx;
            if (!this.isWritable() || currentCtx == null) {
                sendFuture.tryCancel();
                return;
            }
            DataInOut combinedData = new DataInOut();
            this.context.remoteDataToArray((DataOut)combinedData);
            if (combinedData.getSizeForRead() == 0) {
                sendFuture.tryDone();
                return;
            }
            byte[] payload = combinedData.toArray();
            if (this.isUdp) {
                ByteBuf buf = currentCtx.alloc().buffer(payload.length);
                buf.writeBytes(payload);
                dataToSend = new DatagramPacket(buf, new InetSocketAddress(this.uri.getHost(), this.uri.getPort()));
            } else {
                dataToSend = payload;
            }
            currentCtx.writeAndFlush(dataToSend).addListener(future -> {
                try (LNode.AutoCloseable _l_listener = this.logContext.context();){
                    if (future.isSuccess()) {
                        sendFuture.tryDone();
                    } else {
                        sendFuture.tryError(future.cause());
                    }
                }
            });
        }
    }

    public void read() {
    }

    public void stopRead() {
    }

    public AFuture write(byte[] data) {
        try (LNode.AutoCloseable _l = this.logContext.context();){
            ChannelHandlerContext currentCtx = this.ctx;
            if (this.isWritable() && currentCtx != null) {
                Object dataToSend;
                AFuture res = AFuture.make();
                if (this.isUdp) {
                    ByteBuf buf = currentCtx.alloc().buffer(data.length);
                    buf.writeBytes(data);
                    dataToSend = new DatagramPacket(buf, new InetSocketAddress(this.uri.getHost(), this.uri.getPort()));
                } else {
                    dataToSend = data;
                }
                currentCtx.writeAndFlush(dataToSend).addListener(future -> {
                    try (LNode.AutoCloseable _l_listener = this.logContext.context();){
                        if (future.isSuccess()) {
                            res.tryDone();
                        } else {
                            Log.warn((String)"Netty client raw write failed", (Throwable)future.cause(), (Object[])new Object[0]);
                            res.tryError(future.cause());
                        }
                    }
                });
                AFuture aFuture = res;
                return aFuture;
            }
            AFuture aFuture = AFuture.canceled();
            return aFuture;
        }
    }

    public LT getLocalApi() {
        return this.localApi;
    }

    public RT getRemoteApi() {
        return this.remoteApi;
    }

    public boolean isWritable() {
        ChannelHandlerContext currentCtx = this.ctx;
        return this.active && currentCtx != null && currentCtx.channel().isWritable();
    }

    public FastFutureContext getMetaContext() {
        return this.context;
    }

    public AFuture destroy(boolean force) {
        try (LNode.AutoCloseable _l = this.logContext.context();){
            Log.info((String)"Destroying Netty client", (LNode[])new LNode[0]);
        }
        this.active = false;
        AFuture res = AFuture.make();
        ChannelHandlerContext currentCtx = this.ctx;
        if (currentCtx != null) {
            currentCtx.close().addListener(future -> {
                if (future.isSuccess()) {
                    res.tryDone();
                } else {
                    res.tryError(future.cause());
                }
            });
        } else {
            res.tryDone();
        }
        res.to(() -> {
            this.nettyNet.releaseSharedResources();
            Log.debug((String)"Netty client destroy complete, released resources.", (LNode[])new LNode[0]);
        });
        return res;
    }

    private static class NettyWebSocketClientHandshakerHandler
    extends ChannelInboundHandlerAdapter {
        private final WebSocketClientHandshaker handshaker;
        private final LNode logContext;
        private final Consumer<ChannelHandlerContext> onHandshakeComplete;
        private final Runnable onChannelInactive;

        public NettyWebSocketClientHandshakerHandler(WebSocketClientHandshaker handshaker, LNode logContext, Consumer<ChannelHandlerContext> onHandshakeComplete, Runnable onChannelInactive) {
            this.handshaker = handshaker;
            this.logContext = logContext;
            this.onHandshakeComplete = onHandshakeComplete;
            this.onChannelInactive = onChannelInactive;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            this.handshaker.handshake(ctx.channel());
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            try (LNode.AutoCloseable _l = this.logContext.context();){
                Log.info((String)"WebSocket connection closed", (LNode[])new LNode[0]);
                this.onChannelInactive.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            try (LNode.AutoCloseable _l = this.logContext.context();){
                if (!this.handshaker.isHandshakeComplete()) {
                    try {
                        this.handshaker.finishHandshake(ctx.channel(), (FullHttpResponse)msg);
                        Log.info((String)"WebSocket handshake completed", (LNode[])new LNode[0]);
                        this.onHandshakeComplete.accept(ctx);
                    }
                    catch (Exception e) {
                        Log.error((String)"WebSocket handshake failed", (Throwable)e, (Object[])new Object[0]);
                        ctx.close();
                    }
                    finally {
                        ((FullHttpResponse)msg).release();
                    }
                    return;
                }
                if (msg instanceof FullHttpResponse) {
                    FullHttpResponse response = (FullHttpResponse)msg;
                    Log.error((String)"Unexpected FullHttpResponse after handshake", (Object[])new Object[]{"status", response.status()});
                    response.release();
                    ctx.close();
                    return;
                }
                if (msg instanceof WebSocketFrame) {
                    ctx.fireChannelRead(msg);
                } else {
                    Log.warn((String)"Received non-WebSocketFrame message after handshake", (Object[])new Object[]{"type", msg.getClass().getName()});
                    ReferenceCountUtil.release((Object)msg);
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            try (LNode.AutoCloseable _l = this.logContext.context();){
                Log.error((String)"WebSocket client error", (Throwable)cause, (Object[])new Object[0]);
            }
            if (!this.handshaker.isHandshakeComplete()) {
                Log.error((String)"WebSocket handshake failed during exception", (Throwable)cause, (Object[])new Object[0]);
            }
            ctx.close();
        }
    }
}

