/*
 * Decompiled with CFR 0.152.
 */
package io.aether.net.fastMeta.netty;

import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.net.fastMeta.FastMetaApi;
import io.aether.net.fastMeta.FastMetaClient;
import io.aether.net.fastMeta.FastMetaNet;
import io.aether.net.fastMeta.FastMetaServer;
import io.aether.net.fastMeta.RemoteApi;
import io.aether.net.fastMeta.netty.NettyFastMetaClient;
import io.aether.net.fastMeta.netty.NettyFastMetaServer;
import io.aether.utils.interfaces.AFunction;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.Future;
import java.net.URI;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class NettyFastMetaNet
implements FastMetaNet,
AutoCloseable {
    private static final String TRANSPORT_NAME;
    private static final Class<? extends ServerChannel> SERVER_CHANNEL_CLASS;
    private static final Class<? extends Channel> CLIENT_CHANNEL_CLASS;
    private final AtomicInteger refCounter = new AtomicInteger(0);
    private final AtomicReference<EventLoopGroup> workerGroupRef = new AtomicReference();
    private final AtomicReference<EventLoopGroup> bossGroupRef = new AtomicReference();

    private EventLoopGroup createWorkerGroup() {
        Log.info((String)"Initializing Netty Worker EventLoopGroup (first use)...", (Object[])new Object[]{"transport", TRANSPORT_NAME});
        ThreadFactory factory = new ThreadFactory(this){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "fastmeta-netty-worker-" + this.threadNumber.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        };
        if (Epoll.isAvailable()) {
            return new EpollEventLoopGroup(0, factory);
        }
        if (KQueue.isAvailable()) {
            return new KQueueEventLoopGroup(0, factory);
        }
        return new NioEventLoopGroup(0, factory);
    }

    private EventLoopGroup createBossGroup() {
        Log.info((String)"Initializing Netty Boss EventLoopGroup (first server use)...", (Object[])new Object[]{"transport", TRANSPORT_NAME});
        ThreadFactory factory = new ThreadFactory(this){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "fastmeta-netty-boss-" + this.threadNumber.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        };
        if (Epoll.isAvailable()) {
            return new EpollEventLoopGroup(1, factory);
        }
        if (KQueue.isAvailable()) {
            return new KQueueEventLoopGroup(1, factory);
        }
        return new NioEventLoopGroup(1, factory);
    }

    private EventLoopGroup ensureWorkerInitialized() {
        EventLoopGroup currentGroup;
        while ((currentGroup = this.workerGroupRef.get()) == null) {
            EventLoopGroup newGroup = this.createWorkerGroup();
            if (this.workerGroupRef.compareAndSet(null, newGroup)) {
                Log.info((String)("Netty WorkerGroup started using " + TRANSPORT_NAME + " transport"), (LNode[])new LNode[0]);
                return newGroup;
            }
            Log.debug((String)"Lost CAS race, shutting down redundant WorkerGroup", (LNode[])new LNode[0]);
            this.shutdownGroup(newGroup);
        }
        return currentGroup;
    }

    private EventLoopGroup ensureBossInitialized() {
        EventLoopGroup currentGroup;
        while ((currentGroup = this.bossGroupRef.get()) == null) {
            EventLoopGroup newGroup = this.createBossGroup();
            if (this.bossGroupRef.compareAndSet(null, newGroup)) {
                Log.info((String)("Netty BossGroup started using " + TRANSPORT_NAME + " transport"), (LNode[])new LNode[0]);
                return newGroup;
            }
            Log.debug((String)"Lost CAS race, shutting down redundant BossGroup", (LNode[])new LNode[0]);
            this.shutdownGroup(newGroup);
        }
        return currentGroup;
    }

    private void shutdownGroup(EventLoopGroup group) {
        if (group == null) {
            return;
        }
        Log.info((String)("Shutting down EventLoopGroup: " + group.getClass().getSimpleName()), (LNode[])new LNode[0]);
        Future shutdownFuture = group.shutdownGracefully(0L, 7L, TimeUnit.SECONDS);
        try {
            shutdownFuture.await();
            Log.info((String)"EventLoopGroup shut down successfully.", (LNode[])new LNode[0]);
        }
        catch (InterruptedException e) {
            Log.warn((String)"Interrupted while waiting for Netty shutdown", (Throwable)e, (Object[])new Object[0]);
            Thread.currentThread().interrupt();
        }
    }

    public void acquireSharedResources() {
        int users = this.refCounter.incrementAndGet();
        Log.debug((String)("Acquired Netty resources. Active users: " + users), (LNode[])new LNode[0]);
        this.ensureWorkerInitialized();
    }

    public void releaseSharedResources() {
        int users = this.refCounter.decrementAndGet();
        Log.debug((String)("Released Netty resources. Active users: " + users), (LNode[])new LNode[0]);
    }

    @Override
    public void close() {
        Log.warn((String)"NettyFastMetaNet.close() called on singleton. Releasing one reference.", (LNode[])new LNode[0]);
        this.releaseSharedResources();
    }

    public Class<? extends ServerChannel> getServerChannelClass() {
        return SERVER_CHANNEL_CLASS;
    }

    public Class<? extends Channel> getClientChannelClass() {
        return CLIENT_CHANNEL_CLASS;
    }

    public EventLoopGroup getWorkerGroup() {
        return this.ensureWorkerInitialized();
    }

    public EventLoopGroup getBossGroup() {
        return this.ensureBossInitialized();
    }

    public <LT, RT extends RemoteApi> FastMetaClient<LT, RT> makeClient(URI uri, FastMetaApi<LT, ?> lt, FastMetaApi<?, RT> rt, AFunction<RT, LT> localApi, FastMetaNet.WritableConsumer writableConsumer) {
        this.acquireSharedResources();
        Log.info((String)"Creating Netty FastMeta client", (Object[])new Object[]{"uri", uri});
        try {
            return this.createClientInstance(uri, lt, rt, localApi, writableConsumer);
        }
        catch (Exception e) {
            this.releaseSharedResources();
            throw e;
        }
    }

    private <LT, RT extends RemoteApi> FastMetaClient<LT, RT> createClientInstance(URI uri, FastMetaApi<LT, ?> lt, FastMetaApi<?, RT> rt, AFunction<RT, LT> localApi, FastMetaNet.WritableConsumer writableConsumer) {
        switch (uri.getScheme()) {
            case "tcp": 
            case "udp": 
            case "ws": 
            case "wss": {
                return new NettyFastMetaClient<LT, RT>(this, uri, lt, rt, localApi, writableConsumer);
            }
        }
        throw new IllegalArgumentException("Unsupported scheme: " + uri.getScheme());
    }

    public <LT, RT extends RemoteApi> FastMetaServer<LT, RT> makeServer(URI uri, FastMetaApi<LT, ?> localApiMeta, FastMetaApi<?, RT> remoteApiMeta, FastMetaServer.Handler<LT, RT> handler) {
        this.acquireSharedResources();
        Log.info((String)"Creating Netty FastMeta server", (Object[])new Object[]{"uri", uri});
        try {
            return this.createServerInstance(uri, localApiMeta, remoteApiMeta, handler);
        }
        catch (Exception e) {
            this.releaseSharedResources();
            throw e;
        }
    }

    private <LT, RT extends RemoteApi> FastMetaServer<LT, RT> createServerInstance(URI uri, FastMetaApi<LT, ?> localApiMeta, FastMetaApi<?, RT> remoteApiMeta, FastMetaServer.Handler<LT, RT> handler) {
        switch (uri.getScheme()) {
            case "tcp": 
            case "udp": 
            case "ws": 
            case "wss": {
                return new NettyFastMetaServer<LT, RT>(this, uri, localApiMeta, remoteApiMeta, handler);
            }
        }
        throw new IllegalArgumentException("Unsupported scheme: ".concat(uri.getScheme()));
    }

    static {
        if (Epoll.isAvailable()) {
            TRANSPORT_NAME = "Epoll";
            SERVER_CHANNEL_CLASS = EpollServerSocketChannel.class;
            CLIENT_CHANNEL_CLASS = EpollSocketChannel.class;
        } else if (KQueue.isAvailable()) {
            TRANSPORT_NAME = "KQueue";
            SERVER_CHANNEL_CLASS = KQueueServerSocketChannel.class;
            CLIENT_CHANNEL_CLASS = KQueueSocketChannel.class;
        } else {
            TRANSPORT_NAME = "NIO";
            SERVER_CHANNEL_CLASS = NioServerSocketChannel.class;
            CLIENT_CHANNEL_CLASS = NioSocketChannel.class;
        }
        FastMetaNet.INSTANCE.set(new NettyFastMetaNet());
        Log.info((String)"NettyFastMetaNet registered: $nativeTransport", (Object[])new Object[]{"nativeTransport", TRANSPORT_NAME});
    }
}

