/*
 * Decompiled with CFR 0.152.
 */
package io.aether.net.fastMeta.netty;

import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.net.fastMeta.FastMetaApi;
import io.aether.net.fastMeta.FastMetaNet;
import io.aether.net.fastMeta.FastMetaServer;
import io.aether.net.fastMeta.RemoteApi;
import io.aether.net.fastMeta.netty.FastMetaFrameDecoder;
import io.aether.net.fastMeta.netty.FastMetaFrameEncoder;
import io.aether.net.fastMeta.netty.NettyFastMetaNet;
import io.aether.net.fastMeta.netty.NettyServerConnectionHandler;
import io.aether.utils.ConcurrentHashSet;
import io.aether.utils.futures.AFuture;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class NettyFastMetaServer<LT, RT extends RemoteApi>
implements FastMetaServer<LT, RT> {
    private final LNode logContext;
    private final Channel serverChannel;
    private final FastMetaServer.Handler<LT, RT> handler;
    private final boolean isUdp;
    private final NettyFastMetaNet nettyNet;
    private final Map<FastMetaNet.Connection<LT, RT>, Boolean> tcpConnections = new ConcurrentHashMap<FastMetaNet.Connection<LT, RT>, Boolean>();
    private UdpServerHandler udpHandler;

    NettyFastMetaServer(NettyFastMetaNet nettyNet, URI uri, FastMetaApi<LT, ?> localApiMeta, FastMetaApi<?, RT> remoteApiMeta, FastMetaServer.Handler<LT, RT> handler) {
        this.nettyNet = nettyNet;
        this.handler = handler;
        this.logContext = Log.of((Object[])new Object[]{"uri", uri, "socket", "server netty"});
        this.isUdp = "udp".equals(uri.getScheme());
        this.serverChannel = this.isUdp ? this.startUdpServer(uri, localApiMeta, remoteApiMeta, handler) : this.startTcpServer(uri, localApiMeta, remoteApiMeta, handler);
    }

    private Channel startTcpServer(URI uri, final FastMetaApi<LT, ?> localApiMeta, final FastMetaApi<?, RT> remoteApiMeta, final FastMetaServer.Handler<LT, RT> handler) {
        Channel channel;
        block10: {
            LNode.AutoCloseable _l = this.logContext.context();
            try {
                boolean isWebSocket;
                boolean bl = isWebSocket = "ws".equals(uri.getScheme()) || "wss".equals(uri.getScheme());
                if (isWebSocket) {
                    Log.info((String)"Starting Netty WebSocket server...", (LNode[])new LNode[0]);
                } else {
                    Log.info((String)"Starting Netty TCP server...", (LNode[])new LNode[0]);
                }
                ServerBootstrap b = new ServerBootstrap();
                ((ServerBootstrap)((ServerBootstrap)b.group(this.nettyNet.getBossGroup(), this.nettyNet.getWorkerGroup()).channel(this.nettyNet.getServerChannelClass())).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(this){
                    final /* synthetic */ NettyFastMetaServer this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void initChannel(SocketChannel ch) {
                        try (LNode.AutoCloseable connectionLogContext = this.this$0.logContext.add(new Object[]{"remote", ch.remoteAddress()}).context();){
                            Log.info((String)"Accepted new connection", (LNode[])new LNode[0]);
                            NettyServerConnectionHandler connHandler = new NettyServerConnectionHandler((Channel)ch, connectionLogContext.node(), localApiMeta, remoteApiMeta, handler, this.this$0::onConnectionClosed);
                            if (isWebSocket) {
                                ch.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec(), new HttpObjectAggregator(65536), new WebSocketServerProtocolHandler("/", null, true)});
                                ch.pipeline().addLast("ws_to_buf_decoder", (ChannelHandler)new MessageToMessageDecoder<BinaryWebSocketFrame>(this){

                                    protected void decode(ChannelHandlerContext ctx, BinaryWebSocketFrame msg, List<Object> out) {
                                        out.add(msg.content().retain());
                                    }
                                });
                                ch.pipeline().addLast("frameDecoder", (ChannelHandler)new FastMetaFrameDecoder());
                                ch.pipeline().addLast("buf_to_ws_encoder", (ChannelHandler)new MessageToMessageEncoder<ByteBuf>(this){

                                    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) {
                                        out.add(new BinaryWebSocketFrame(msg.retain()));
                                    }
                                });
                                ch.pipeline().addLast("frameEncoder", (ChannelHandler)new FastMetaFrameEncoder());
                                ch.pipeline().addLast("handler", connHandler);
                            } else {
                                ch.pipeline().addLast("frameDecoder", (ChannelHandler)new FastMetaFrameDecoder());
                                ch.pipeline().addLast("frameEncoder", (ChannelHandler)new FastMetaFrameEncoder());
                                ch.pipeline().addLast("handler", connHandler);
                            }
                            this.this$0.tcpConnections.put(connHandler, true);
                        }
                        catch (Exception e) {
                            Log.warn((String)"Failed to initialize new connection pipeline", (Throwable)e, (Object[])new Object[0]);
                            ch.close();
                        }
                    }
                });
                ChannelFuture bindFuture = b.bind(uri.getHost(), uri.getPort());
                Channel ch = bindFuture.sync().channel();
                String protocol = isWebSocket ? "WebSocket" : "TCP";
                Log.info((String)("Netty " + protocol + " server started and listening on " + uri.getHost() + ":" + uri.getPort()), (LNode[])new LNode[0]);
                channel = ch;
                if (_l == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (_l != null) {
                        try {
                            _l.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Log.error((String)"Failed to start Netty server", (Throwable)e, (Object[])new Object[0]);
                    throw new RuntimeException("Failed to start Netty server", e);
                }
            }
            _l.close();
        }
        return channel;
    }

    private Channel startUdpServer(URI uri, FastMetaApi<LT, ?> localApiMeta, FastMetaApi<?, RT> remoteApiMeta, FastMetaServer.Handler<LT, RT> handler) {
        Channel channel;
        block8: {
            LNode.AutoCloseable _l = this.logContext.context();
            try {
                Log.info((String)"Starting Netty UDP server...", (LNode[])new LNode[0]);
                this.udpHandler = new UdpServerHandler(localApiMeta, remoteApiMeta, handler);
                Class<DatagramChannel> datagramChannelClass = this.getDatagramChannelClass();
                Bootstrap b = new Bootstrap();
                ((Bootstrap)((Bootstrap)((Bootstrap)b.group(this.nettyNet.getWorkerGroup())).channel(datagramChannelClass)).option(ChannelOption.SO_BROADCAST, (Object)false)).handler((ChannelHandler)this.udpHandler);
                ChannelFuture bindFuture = b.bind(uri.getHost(), uri.getPort());
                Channel ch = bindFuture.sync().channel();
                Log.info((String)("Netty UDP server started and listening on " + uri.getHost() + ":" + uri.getPort()), (LNode[])new LNode[0]);
                channel = ch;
                if (_l == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (_l != null) {
                        try {
                            _l.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Log.error((String)"Failed to start Netty UDP server", (Throwable)e, (Object[])new Object[0]);
                    throw new RuntimeException("Failed to start Netty UDP server", e);
                }
            }
            _l.close();
        }
        return channel;
    }

    private Class<? extends DatagramChannel> getDatagramChannelClass() {
        Class<? extends Channel> clientChannelClass = this.nettyNet.getClientChannelClass();
        if (clientChannelClass == EpollSocketChannel.class) {
            return EpollDatagramChannel.class;
        }
        if (clientChannelClass == KQueueSocketChannel.class) {
            return KQueueDatagramChannel.class;
        }
        return NioDatagramChannel.class;
    }

    private void onConnectionClosed(FastMetaNet.Connection<LT, RT> connection) {
        if (this.tcpConnections.remove(connection) != null) {
            Log.info((String)"TCP connection removed from server", (LNode)((NettyServerConnectionHandler)connection).getLogContext());
        }
    }

    public AFuture stop() {
        return this.destroy(false);
    }

    public AFuture destroy(boolean force) {
        Log.info((String)"Destroying Netty server...", (Object[])new Object[]{this.logContext, "isUdp", this.isUdp});
        AFuture res = AFuture.make();
        for (FastMetaNet.Connection<LT, RT> conn : this.handlers()) {
            conn.destroy(force);
        }
        if (this.isUdp) {
            this.udpHandler.clearConnections();
        } else {
            this.tcpConnections.clear();
        }
        this.serverChannel.close().addListener(future -> {
            if (future.isSuccess()) {
                Log.info((String)"Netty server socket closed", (LNode)this.logContext);
                res.tryDone();
            } else {
                Log.warn((String)"Error closing Netty server socket", (Throwable)future.cause(), (Object[])new Object[0]);
                res.tryError(future.cause());
            }
        });
        res.to(() -> {
            this.nettyNet.releaseSharedResources();
            Log.debug((String)"Netty server destroy complete, released resources.", (LNode[])new LNode[0]);
        });
        return res;
    }

    public Iterable<FastMetaNet.Connection<LT, RT>> handlers() {
        if (this.isUdp) {
            return new ConcurrentHashSet(this.udpHandler.getConnections());
        }
        return new ConcurrentHashSet(this.tcpConnections.keySet());
    }

    private class UdpServerHandler
    extends ChannelInboundHandlerAdapter {
        private final Map<SocketAddress, NettyServerConnectionHandler<LT, RT>> udpConnections = new ConcurrentHashMap();
        private final FastMetaApi<LT, ?> localApiMeta;
        private final FastMetaApi<?, RT> remoteApiMeta;
        private final FastMetaServer.Handler<LT, RT> serverHandler;
        private ChannelHandlerContext mainCtx;

        UdpServerHandler(FastMetaApi<LT, ?> localApiMeta, FastMetaApi<?, RT> remoteApiMeta, FastMetaServer.Handler<LT, RT> serverHandler) {
            this.localApiMeta = localApiMeta;
            this.remoteApiMeta = remoteApiMeta;
            this.serverHandler = serverHandler;
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            this.mainCtx = ctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (!(msg instanceof DatagramPacket)) {
                return;
            }
            DatagramPacket packet = (DatagramPacket)msg;
            SocketAddress sender = packet.sender();
            try (LNode.AutoCloseable connectionLogContext = NettyFastMetaServer.this.logContext.add(new Object[]{"remote", sender}).context();){
                NettyServerConnectionHandler conn = this.udpConnections.get(sender);
                if (conn == null) {
                    Log.info((String)"Accepted new UDP connection", (LNode[])new LNode[0]);
                    conn = new NettyServerConnectionHandler(this.mainCtx, sender, connectionLogContext.node(), this.localApiMeta, this.remoteApiMeta, this.serverHandler, this::onUdpConnectionClosed);
                    conn.udpInit();
                    this.udpConnections.put(sender, conn);
                }
                conn.channelRead(ctx, ((ByteBuf)packet.content()).retain());
            }
            catch (Exception e) {
                Log.error((String)"Error processing UDP datagram", (Throwable)e, (Object[])new Object[0]);
            }
            finally {
                packet.release();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            try (LNode.AutoCloseable _l = NettyFastMetaServer.this.logContext.context();){
                Log.warn((String)"Netty UDP server handler exception caught", (Throwable)cause, (Object[])new Object[0]);
            }
        }

        private void onUdpConnectionClosed(SocketAddress remoteAddress, FastMetaNet.Connection<LT, RT> connection) {
            if (this.udpConnections.remove(remoteAddress, connection)) {
                Log.info((String)"UDP connection removed from server", (LNode)((NettyServerConnectionHandler)connection).getLogContext());
                NettyFastMetaServer.this.onConnectionClosed(connection);
            }
        }

        public Collection<FastMetaNet.Connection<LT, RT>> getConnections() {
            return new HashSet(this.udpConnections.values());
        }

        public void clearConnections() {
            this.udpConnections.clear();
        }
    }
}

