/*
 * Decompiled with CFR 0.152.
 */
package io.aether.net.fastMeta.netty;

import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.net.fastMeta.FastApiContext;
import io.aether.net.fastMeta.FastFutureContext;
import io.aether.net.fastMeta.FastMetaApi;
import io.aether.net.fastMeta.FastMetaNet;
import io.aether.net.fastMeta.FastMetaServer;
import io.aether.net.fastMeta.RemoteApi;
import io.aether.net.fastMeta.netty.ByteBufDataIO;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataInOut;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.futures.AFuture;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

class NettyServerConnectionHandler<LT, RT extends RemoteApi>
extends ChannelInboundHandlerAdapter
implements FastMetaNet.Connection<LT, RT> {
    private final FastMetaApi<LT, ?> localApiMeta;
    private final FastMetaApi<?, RT> remoteApiMeta;
    private final FastMetaServer.Handler<LT, RT> serverHandler;
    private final LNode logContext;
    private final Channel channel;
    private final Consumer<FastMetaNet.Connection<LT, RT>> tcpCloseCallback;
    private final ChannelHandlerContext mainCtx;
    private final SocketAddress remoteAddress;
    private final BiConsumer<SocketAddress, FastMetaNet.Connection<LT, RT>> udpCloseCallback;
    private ChannelHandlerContext ctx;
    private FastApiContext context;
    private RT remoteApi;
    private LT localApi;

    NettyServerConnectionHandler(Channel channel, LNode parentLogContext, FastMetaApi<LT, ?> localApiMeta, FastMetaApi<?, RT> remoteApiMeta, FastMetaServer.Handler<LT, RT> serverHandler, Consumer<FastMetaNet.Connection<LT, RT>> closeCallback) {
        this.channel = channel;
        this.localApiMeta = localApiMeta;
        this.remoteApiMeta = remoteApiMeta;
        this.serverHandler = serverHandler;
        this.tcpCloseCallback = closeCallback;
        this.logContext = parentLogContext;
        this.mainCtx = null;
        this.remoteAddress = null;
        this.udpCloseCallback = null;
    }

    NettyServerConnectionHandler(ChannelHandlerContext mainCtx, SocketAddress remoteAddress, LNode parentLogContext, FastMetaApi<LT, ?> localApiMeta, FastMetaApi<?, RT> remoteApiMeta, FastMetaServer.Handler<LT, RT> serverHandler, BiConsumer<SocketAddress, FastMetaNet.Connection<LT, RT>> udpCloseCallback) {
        this.mainCtx = mainCtx;
        this.remoteAddress = remoteAddress;
        this.localApiMeta = localApiMeta;
        this.remoteApiMeta = remoteApiMeta;
        this.serverHandler = serverHandler;
        this.udpCloseCallback = udpCloseCallback;
        this.logContext = parentLogContext;
        this.channel = null;
        this.tcpCloseCallback = null;
    }

    public LNode getLogContext() {
        return this.logContext;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.ctx = ctx;
        this.initializeApis();
    }

    public void udpInit() {
        this.ctx = this.mainCtx;
        this.initializeApis();
    }

    private void initializeApis() {
        block8: {
            this.context = new FastApiContext(){

                public void flush(AFuture sendFuture) {
                    NettyServerConnectionHandler.this.handleFlush(sendFuture);
                }
            };
            this.remoteApi = this.remoteApiMeta.makeRemote((FastFutureContext)this.context);
            try (LNode.AutoCloseable _l = this.logContext.context();){
                this.localApi = this.serverHandler.onNewConnection((FastMetaNet.Connection)this);
            }
            catch (Exception e) {
                Log.error((String)"Handler onNewConnection failed, closing connection", (Throwable)e, (Object[])new Object[]{this.logContext});
                this.ctx.close();
                if (this.remoteAddress == null) break block8;
                this.destroy(true);
            }
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.runCloseLogic();
        this.tcpCloseCallback.accept(this);
    }

    private void runCloseLogic() {
        try (LNode.AutoCloseable _l = this.logContext.context();){
            Log.info((String)"Connection closed", (LNode[])new LNode[0]);
            this.serverHandler.onConnectionClose((FastMetaNet.Connection)this);
        }
        catch (Exception e) {
            Log.warn((String)"Handler onConnectionClose failed", (Throwable)e, (Object[])new Object[]{this.logContext});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof ByteBuf) {
            ByteBuf payload = (ByteBuf)msg;
            try (LNode.AutoCloseable _l = this.logContext.context();){
                try {
                    ByteBufDataIO in = new ByteBufDataIO(payload);
                    this.localApiMeta.makeLocal((FastFutureContext)this.context, (DataIn)in, this.localApi);
                }
                catch (Exception e) {
                    Log.error((String)"Error during makeLocal (packet processing).", (Throwable)e, (Object[])new Object[0]);
                    if (this.channel != null) {
                        ctx.close();
                    }
                }
                finally {
                    if (payload != null) {
                        payload.release();
                    }
                }
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        try (LNode.AutoCloseable _l = this.logContext.context();){
            Log.warn((String)"Netty server connection exception caught", (Throwable)cause, (Object[])new Object[0]);
            ctx.close();
        }
    }

    private void handleFlush(AFuture sendFuture) {
        try (LNode.AutoCloseable _l = this.logContext.context();){
            Object packetToWrite;
            if (!this.isWritable()) {
                sendFuture.tryCancel();
                return;
            }
            DataInOut combinedData = new DataInOut();
            this.context.remoteDataToArray((DataOut)combinedData);
            if (combinedData.getSizeForRead() == 0) {
                sendFuture.tryDone();
                return;
            }
            byte[] payload = combinedData.toArray();
            if (this.remoteAddress == null) {
                packetToWrite = payload;
            } else {
                ByteBuf buf = this.ctx.alloc().buffer(payload.length);
                buf.writeBytes(payload);
                packetToWrite = new DatagramPacket(buf, (InetSocketAddress)this.remoteAddress);
            }
            this.ctx.writeAndFlush(packetToWrite).addListener(future -> {
                try (LNode.AutoCloseable _l_listener = this.logContext.context();){
                    if (future.isSuccess()) {
                        sendFuture.tryDone();
                    } else {
                        sendFuture.tryError(future.cause());
                    }
                }
            });
        }
    }

    public void read() {
    }

    public void stopRead() {
    }

    public AFuture write(byte[] data) {
        try (LNode.AutoCloseable _l = this.logContext.context();){
            Object packetToWrite;
            if (!this.isWritable()) {
                AFuture aFuture = AFuture.canceled();
                return aFuture;
            }
            AFuture res = AFuture.make();
            if (this.remoteAddress == null) {
                packetToWrite = data;
            } else {
                ByteBuf buf = this.ctx.alloc().buffer(data.length);
                buf.writeBytes(data);
                packetToWrite = new DatagramPacket(buf, (InetSocketAddress)this.remoteAddress);
            }
            this.ctx.writeAndFlush(packetToWrite).addListener(future -> {
                try (LNode.AutoCloseable _l_listener = this.logContext.context();){
                    if (future.isSuccess()) {
                        res.tryDone();
                    } else {
                        Log.warn((String)"Netty server raw write failed", (Throwable)future.cause(), (Object[])new Object[0]);
                        res.tryError(future.cause());
                    }
                }
            });
            AFuture aFuture = res;
            return aFuture;
        }
    }

    public LT getLocalApi() {
        return this.localApi;
    }

    public RT getRemoteApi() {
        return this.remoteApi;
    }

    public boolean isWritable() {
        return this.channel != null && this.channel.isOpen() && this.channel.isWritable() || this.mainCtx != null && this.mainCtx.channel().isWritable();
    }

    public FastFutureContext getMetaContext() {
        return this.context;
    }

    public AFuture destroy(boolean force) {
        AFuture res = AFuture.make();
        if (this.remoteAddress == null) {
            this.ctx.close().addListener(future -> {
                if (future.isSuccess()) {
                    res.tryDone();
                } else {
                    res.tryError(future.cause());
                }
            });
        } else {
            this.runCloseLogic();
            this.udpCloseCallback.accept(this.remoteAddress, this);
            res.tryDone();
        }
        return res;
    }
}

