package io.aether.net.fastMeta.nio;

import java.nio.channels.SelectionKey;

/**
 * An internal interface for objects that can handle I/O events
 * dispatched by the {@link io.aether.net.fastMeta.nio.NioReactor}.
 */
interface NioEventHandler {

    /**
     * Called by the {@link io.aether.net.fastMeta.nio.NioReactor} when an I/O event is ready for this handler.
     *
     * @param key The {@link SelectionKey} associated with the event.
     * @throws Exception If an error occurs during event handling.
     */
    void handleEvent(SelectionKey key) throws Exception;

    /**
     * Called by the {@link io.aether.net.fastMeta.nio.NioReactor} or the object itself to signal
     * a fatal error or a required shutdown.
     *
     * @param e The exception that caused the closure, or null.
     */
    void closeConnection(Exception e);
}