/*
 * Decompiled with CFR 0.152.
 */
package io.aether.net.fastMeta.nio;

import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.net.fastMeta.FastMetaApi;
import io.aether.net.fastMeta.FastMetaClient;
import io.aether.net.fastMeta.FastMetaNet;
import io.aether.net.fastMeta.FastMetaServer;
import io.aether.net.fastMeta.RemoteApi;
import io.aether.net.fastMeta.nio.NioReactor;
import io.aether.net.fastMeta.nio.NioTcpFastMetaClient;
import io.aether.net.fastMeta.nio.NioTcpFastMetaServer;
import io.aether.utils.Destroyer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.interfaces.Destroyable;
import java.io.IOException;
import java.net.URI;

public class NioFastMetaNet
implements FastMetaNet,
AutoCloseable {
    private final NioReactor reactor;
    private final Thread reactorThread;
    private final Destroyer destroyer = new Destroyer("NioFastMetaNet");

    public NioFastMetaNet() {
        try {
            this.reactor = new NioReactor();
            this.reactorThread = new Thread((Runnable)this.reactor, "fastmeta-nio-reactor");
            this.reactorThread.setDaemon(true);
            this.reactorThread.start();
            Log.info((String)"NIO Reactor thread started", (LNode[])new LNode[0]);
            this.addReactorShutdownHook();
        }
        catch (IOException e) {
            Log.error((String)"Failed to initialize NIO Reactor", (Throwable)e, (Object[])new Object[0]);
            throw new RuntimeException("Failed to initialize NIO Reactor", e);
        }
    }

    private void addReactorShutdownHook() {
        this.destroyer.add(new Destroyable(){

            public String toString() {
                return "NioReactor-Shutdown";
            }

            public AFuture destroy(boolean force) {
                Log.info((String)"NioReactor stopping...", (LNode[])new LNode[0]);
                NioFastMetaNet.this.reactor.stop();
                try {
                    NioFastMetaNet.this.reactorThread.join(2000L);
                }
                catch (InterruptedException e) {
                    Log.warn((String)"Interrupted while waiting for reactor shutdown", (Throwable)e, (Object[])new Object[0]);
                    Thread.currentThread().interrupt();
                }
                return AFuture.completed();
            }
        });
    }

    @Override
    public void close() {
        Log.info((String)"Shutting down NioFastMetaNet...", (LNode[])new LNode[0]);
        this.destroyer.destroy(false);
    }

    public <LT, RT extends RemoteApi> FastMetaClient<LT, RT> makeClient(URI uri, FastMetaApi<LT, ?> lt, FastMetaApi<?, RT> rt, AFunction<RT, LT> localApi, FastMetaNet.WritableConsumer writableConsumer) {
        Log.info((String)"Creating FastMeta client", (Object[])new Object[]{"uri", uri});
        NioTcpFastMetaClient<LT, RT> client = switch (uri.getScheme()) {
            case "tcp" -> new NioTcpFastMetaClient<LT, RT>(this.reactor, uri, lt, rt, localApi, writableConsumer);
            case "udp" -> {
                Log.error((String)"UDP client is not yet supported", (Object[])new Object[]{"uri", uri});
                throw new UnsupportedOperationException("UDP client not yet implemented");
            }
            case "ws" -> {
                Log.error((String)"WebSocket (ws) client is not yet supported", (Object[])new Object[]{"uri", uri});
                throw new UnsupportedOperationException("WebSocket client not yet implemented");
            }
            default -> {
                Log.error((String)"Unsupported client URI scheme", (Object[])new Object[]{"scheme", uri.getScheme(), "uri", uri});
                throw new IllegalArgumentException("Unsupported scheme: " + uri.getScheme());
            }
        };
        this.destroyer.add(client);
        return client;
    }

    public <LT, RT extends RemoteApi> FastMetaServer<LT, RT> makeServer(URI uri, FastMetaApi<LT, ?> localApiMeta, FastMetaApi<?, RT> remoteApiMeta, FastMetaServer.Handler<LT, RT> handler) {
        Log.info((String)"Creating FastMeta server", (Object[])new Object[]{"uri", uri});
        NioTcpFastMetaServer<LT, RT> server = switch (uri.getScheme()) {
            case "tcp" -> new NioTcpFastMetaServer<LT, RT>(this.reactor, uri, localApiMeta, remoteApiMeta, handler);
            case "udp" -> {
                Log.error((String)"UDP server is not yet supported", (Object[])new Object[]{"uri", uri});
                throw new UnsupportedOperationException("UDP server not yet implemented");
            }
            case "ws" -> {
                Log.error((String)"WebSocket (ws) server is not yet supported", (Object[])new Object[]{"uri", uri});
                throw new UnsupportedOperationException("WebSocket server not yet implemented");
            }
            default -> {
                Log.error((String)"Unsupported server URI scheme", (Object[])new Object[]{"scheme", uri.getScheme(), "uri", uri});
                throw new IllegalArgumentException("Unsupported scheme: " + uri.getScheme());
            }
        };
        this.destroyer.add(server);
        return server;
    }

    static {
        FastMetaNet.INSTANCE.set(new NioFastMetaNet());
        Log.info((String)"NioFastMetaNet registered as FastMetaNet.INSTANCE", (LNode[])new LNode[0]);
    }
}

