/*
 * Decompiled with CFR 0.152.
 */
package io.aether.net.fastMeta.nio;

import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.net.fastMeta.nio.NioEventHandler;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;

class NioReactor
implements Runnable {
    private final Selector selector;
    private final ConcurrentLinkedQueue<Runnable> tasks = new ConcurrentLinkedQueue();
    private volatile boolean running = true;
    private final LNode logContext = Log.of((Object[])new Object[]{"socket", "client nio"});

    NioReactor() throws IOException {
        this.selector = Selector.open();
    }

    public void stop() {
        try (LNode.AutoCloseable _l = this.logContext.context();){
            Log.info((String)"NioReactor stopping...", (LNode[])new LNode[0]);
        }
        this.running = false;
        this.selector.wakeup();
    }

    public void addTask(Runnable task) {
        this.tasks.add(task);
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (LNode.AutoCloseable mainLoopContext = this.logContext.context();){
            Log.info((String)"NioReactor thread started.", (LNode[])new LNode[0]);
            while (this.running) {
                try {
                    this.runPendingTasks();
                    int selectedCount = this.selector.select();
                    if (!this.running) break;
                    if (selectedCount == 0 && this.tasks.isEmpty()) {
                        Log.trace((String)"Selector woke up without keys or tasks.", (LNode[])new LNode[0]);
                        continue;
                    }
                    Iterator<SelectionKey> keys = this.selector.selectedKeys().iterator();
                    while (keys.hasNext()) {
                        SelectionKey key = keys.next();
                        keys.remove();
                        if (!key.isValid()) {
                            Log.trace((String)"Skipping invalid key", (LNode[])new LNode[0]);
                            Object attachment = key.attachment();
                            if (!(attachment instanceof NioEventHandler)) continue;
                            try {
                                ((NioEventHandler)attachment).closeConnection(new IOException("SelectionKey became invalid"));
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        this.dispatch(key);
                    }
                }
                catch (IOException e) {
                    if (!this.running) continue;
                    Log.error((String)"NIO Reactor select() error", (Throwable)e, (Object[])new Object[0]);
                    this.running = false;
                }
                catch (Exception e) {
                    if (!this.running) continue;
                    Log.error((String)"NIO Reactor loop unexpected error", (Throwable)e, (Object[])new Object[0]);
                }
            }
            Log.info((String)"NioReactor loop finished.", (LNode[])new LNode[0]);
        }
        finally {
            try {
                this.selector.close();
                Log.info((String)"NioReactor selector closed", (LNode[])new LNode[0]);
            }
            catch (IOException e) {
                Log.error((String)"Error closing selector", (Throwable)e, (Object[])new Object[0]);
            }
        }
    }

    private void runPendingTasks() {
        Runnable task;
        while ((task = this.tasks.poll()) != null) {
            try {
                task.run();
            }
            catch (Exception e) {
                LNode.AutoCloseable _l = this.logContext.context();
                try {
                    Log.error((String)"Error executing reactor task", (Throwable)e, (Object[])new Object[0]);
                }
                finally {
                    if (_l == null) continue;
                    _l.close();
                }
            }
        }
    }

    private void dispatch(SelectionKey key) {
        Object attachment = key.attachment();
        if (!(attachment instanceof NioEventHandler)) {
            Log.warn((String)"SelectionKey has no NioEventHandler attachment", (Object[])new Object[]{"keyInfo", key.toString()});
            key.cancel();
            return;
        }
        NioEventHandler handler = (NioEventHandler)attachment;
        try {
            handler.handleEvent(key);
        }
        catch (Exception e) {
            Log.warn((String)"NioEventHandler threw an exception during handleEvent", (Throwable)e, (Object[])new Object[]{"handler", handler.toString()});
            try {
                handler.closeConnection(e);
            }
            catch (Exception closeEx) {
                Log.warn((String)"Exception during handler.closeConnection after event error", (Throwable)closeEx, (Object[])new Object[]{"handler", handler.toString()});
            }
        }
    }

    public void register(SelectableChannel channel, int ops, NioEventHandler handler) {
        this.addTask((Runnable)Log.wrap(() -> {
            block6: {
                try {
                    if (!channel.isOpen()) {
                        Log.warn((String)"Attempted to register an already closed channel", (Object[])new Object[]{"handler", handler});
                        if (handler != null) {
                            handler.closeConnection(new ClosedChannelException());
                        }
                        return;
                    }
                    channel.configureBlocking(false);
                    SelectionKey key = channel.register(this.selector, ops, handler);
                    Log.debug((String)"Channel registered successfully", (Object[])new Object[]{"ops", ops, "keyValid", key.isValid(), "handler", handler});
                }
                catch (ClosedChannelException e) {
                    Log.warn((String)"Channel was closed before registration could complete", (Throwable)e, (Object[])new Object[]{"handler", handler});
                    if (handler != null) {
                        handler.closeConnection(e);
                    }
                }
                catch (Exception e) {
                    Log.error((String)"Failed to register channel with selector", (Throwable)e, (Object[])new Object[]{"handler", handler});
                    if (handler == null) break block6;
                    handler.closeConnection(e);
                }
            }
        }));
    }
}

